/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.util.settings.swing.AbstractBasicEditorProvider;
import de.caff.util.settings.swing.SwingFormattedStringProperty;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class FormattedStringEditor<T>
extends AbstractBasicEditorProvider
implements PropertyChangeListener {
    private final SwingFormattedStringProperty<T> property;
    private final JFormattedTextField textField;

    public FormattedStringEditor(@NotNull SwingFormattedStringProperty<T> swingFormattedStringProperty, boolean bl, Locale locale) {
        super(swingFormattedStringProperty, locale);
        this.property = swingFormattedStringProperty;
        this.textField = new JFormattedTextField(swingFormattedStringProperty.getFormatter()){
            private static final long serialVersionUID = 7323470821499499789L;

            @Override
            public void setEnabled(boolean bl) {
                if (this.isEnabled() != bl && !bl) {
                    this.select(0, 0);
                }
                super.setEnabled(bl);
            }
        };
        this.textField.setValue(swingFormattedStringProperty.getValue());
        swingFormattedStringProperty.addValueChangeListenerWeakly(this);
        if (bl) {
            this.textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    FormattedStringEditor.this.saveLater();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    FormattedStringEditor.this.saveLater();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    FormattedStringEditor.this.saveLater();
                }
            });
        }
        this.textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                FormattedStringEditor.this.textField.selectAll();
            }
        });
    }

    @Override
    @NotNull
    public JComponent getEditor() {
        return this.textField;
    }

    @Override
    public void reset() {
        this.textField.setValue(this.property.getValue());
    }

    @Override
    public void save() {
        this.property.setValue(this.textField.getValue());
    }

    public void saveLater() {
        SwingUtilities.invokeLater(this::save);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.textField.getText().equals(propertyChangeEvent.getNewValue().toString())) {
            this.textField.setText(propertyChangeEvent.getNewValue().toString());
        }
    }

    @Override
    public void goodBye() {
        this.property.removeValueChangeListener(this);
    }
}

