/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.util.settings.EnumValue;
import de.caff.util.settings.swing.AbstractBasicEditorProvider;
import de.caff.util.settings.swing.SwingEnumProperty;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;

public class EnumEditor<E>
extends AbstractBasicEditorProvider
implements PropertyChangeListener {
    private final SwingEnumProperty<E> property;
    private JComboBox<EnumValueLocalizer<E>> comboBox;

    public EnumEditor(@NotNull SwingEnumProperty<E> swingEnumProperty, boolean bl, final Locale locale) {
        super(swingEnumProperty, locale);
        this.property = swingEnumProperty;
        ArrayList<EnumValue<E>> arrayList = new ArrayList<EnumValue<E>>(swingEnumProperty.getEnumValues(locale));
        SwingEnumProperty.EnumValueComparator<E> enumValueComparator = swingEnumProperty.getEnumValueComparator();
        if (enumValueComparator != null) {
            enumValueComparator.setLocale(locale);
            Collections.sort(arrayList, enumValueComparator);
        }
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        EnumValue<E> enumValue = swingEnumProperty.getValue();
        int n = arrayList.size() - 1;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) == enumValue) {
                n = i;
            }
            defaultComboBoxModel.addElement(new EnumValueLocalizer((EnumValue)arrayList.get(i), locale));
        }
        this.comboBox = new JComboBox(defaultComboBoxModel);
        if (n >= 0) {
            this.comboBox.setSelectedIndex(n);
        }
        this.comboBox.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 3087615301542781717L;

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object != null) {
                    EnumValue enumValue = (EnumValue)object;
                    jLabel.setToolTipText(enumValue.getLongName(locale));
                    this.setIcon(enumValue.getIcon(locale));
                }
                return jLabel;
            }
        });
        if (bl) {
            this.comboBox.addItemListener(itemEvent -> this.save());
        }
        swingEnumProperty.addValueChangeListenerWeakly(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.comboBox.getModel();
        Object object = propertyChangeEvent.getNewValue();
        for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
            EnumValueLocalizer enumValueLocalizer = (EnumValueLocalizer)defaultComboBoxModel.getElementAt(i);
            if (!enumValueLocalizer.getBasicValue().equals(object)) continue;
            this.comboBox.setSelectedIndex(i);
            break;
        }
    }

    @Override
    @NotNull
    public JComponent getEditor() {
        return this.comboBox;
    }

    @Override
    public void reset() {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.comboBox.getModel();
        this.comboBox = new JComboBox(defaultComboBoxModel);
        EnumValue<E> enumValue = this.property.getValue();
        for (int i = defaultComboBoxModel.getSize() - 1; i >= 0; --i) {
            if (((EnumValueLocalizer)defaultComboBoxModel.getElementAt(i)).getBasicValue() != enumValue) continue;
            this.comboBox.setSelectedIndex(i);
        }
    }

    @Override
    public void save() {
        EnumValueLocalizer enumValueLocalizer = (EnumValueLocalizer)this.comboBox.getSelectedItem();
        this.property.setValue(enumValueLocalizer.getBasicValue());
    }

    @Override
    public void goodBye() {
    }

    private static class EnumValueLocalizer<F>
    implements EnumValue<F> {
        private final EnumValue<F> wrapped;
        private final Locale locale;

        public EnumValueLocalizer(@NotNull EnumValue<F> enumValue, @Nullable Locale locale) {
            this.wrapped = enumValue;
            this.locale = locale;
        }

        @NotNull
        public String getShortName(@Nullable Locale locale) {
            return this.wrapped.getShortName(locale);
        }

        public String getLongName(@Nullable Locale locale) {
            return this.wrapped.getLongName(locale);
        }

        public Icon getIcon(@Nullable Locale locale) {
            return this.wrapped.getIcon(locale);
        }

        public void storeTo(@NotNull Preferences preferences, @NotNull String string) {
            this.wrapped.storeTo(preferences, string);
        }

        public boolean isEqualTo(@NotNull Preferences preferences, @NotNull String string) {
            return this.wrapped.isEqualTo(preferences, string);
        }

        public F getRealValue() {
            return (F)this.wrapped.getRealValue();
        }

        public EnumValue<F> getBasicValue() {
            return this.wrapped;
        }

        public String toString() {
            return this.wrapped.getShortName(this.locale);
        }
    }
}

