/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.util.settings.EnumValue;
import de.caff.util.settings.swing.AbstractBasicEditorProvider;
import de.caff.util.settings.swing.EditorProvider;
import de.caff.util.settings.swing.SwingEnumProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public class EnumCheckedProxyEditorProvider<E>
implements EditorProvider,
PropertyChangeListener {
    @NotNull
    private final SwingEnumProperty<E> enumProperty;
    @NotNull
    private final EnumValue<E> onValue;
    @NotNull
    private final EditorProvider baseEditorProvider;
    private final JRadioButton label;
    private final JComponent editor;
    private final boolean wasOn;

    public EnumCheckedProxyEditorProvider(@NotNull ButtonGroup buttonGroup, @NotNull SwingEnumProperty<E> swingEnumProperty, @NotNull EnumValue<E> enumValue, @NotNull EditorProvider editorProvider) {
        this.enumProperty = swingEnumProperty;
        this.onValue = enumValue;
        this.baseEditorProvider = editorProvider;
        this.label = new JRadioButton(AbstractBasicEditorProvider.getLabelTextWithPunctuation(editorProvider.getLabelText()));
        buttonGroup.add(this.label);
        this.editor = editorProvider.getEditor();
        this.wasOn = swingEnumProperty.getValue() == enumValue;
        this.editor.setEnabled(this.wasOn);
        this.label.setSelected(this.wasOn);
        this.label.addItemListener(itemEvent -> {
            boolean bl = this.label.isSelected();
            this.editor.setEnabled(bl);
            if (bl) {
                swingEnumProperty.setValue(enumValue);
            }
        });
        swingEnumProperty.addValueChangeListenerWeakly(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.label.setSelected(propertyChangeEvent.getNewValue() == this.onValue);
    }

    @Override
    @Nullable
    public String getLabelText() {
        return this.label.getText();
    }

    @Override
    @Nullable
    public JComponent getLabel() {
        return this.label;
    }

    @Override
    @Nullable
    public String getTitleText() {
        return this.baseEditorProvider.getTitleText();
    }

    @Override
    @Nullable
    public String getToolTipText() {
        return this.baseEditorProvider.getToolTipText();
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.baseEditorProvider.getDescription();
    }

    @Override
    @NotNull
    public JComponent getEditor() {
        return this.editor;
    }

    @Override
    public boolean isValidValue() {
        return this.baseEditorProvider.isValidValue();
    }

    @Override
    public void reset() {
        this.baseEditorProvider.reset();
        this.label.setSelected(this.wasOn);
    }

    @Override
    public void save() {
        this.baseEditorProvider.save();
        if (this.label.isSelected()) {
            this.enumProperty.setValue(this.onValue);
        }
    }

    @Override
    public void goodBye() {
    }
}

