/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Types;
import de.caff.i18n.I18n;
import de.caff.util.settings.swing.EditableProperty;
import de.caff.util.settings.swing.EditorProvider;
import de.caff.util.settings.swing.PanelGroupEditor;
import de.caff.util.settings.swing.TabbedGroupEditor;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;

public class EditablePropertyGroup<T extends EditableProperty>
implements EditableProperty {
    protected final Collection<T> propertyList = Types.synchronizedCollection(new LinkedList());
    protected final String nameTag;
    protected final boolean tabbed;
    private int tabIndex = 0;

    public EditablePropertyGroup(@NotNull String string, boolean bl) {
        this.nameTag = string;
        this.tabbed = bl;
    }

    @SafeVarargs
    public EditablePropertyGroup(@NotNull String string, T ... TArray) {
        this(string, false, (EditableProperty[])TArray);
    }

    @SafeVarargs
    public EditablePropertyGroup(@NotNull String string, boolean bl, T ... TArray) {
        this(string, bl);
        if (TArray != null) {
            this.propertyList.addAll(Types.asList((Object[])TArray));
        }
    }

    public EditablePropertyGroup(@NotNull String string, @NotNull Collection<? extends T> collection) {
        this(string, false, collection);
    }

    public EditablePropertyGroup(@NotNull String string, boolean bl, @NotNull Collection<? extends T> collection) {
        this(string, bl);
        this.propertyList.addAll(collection);
    }

    @Override
    @NotNull
    public EditorProvider getEditorProvider(@Nullable Locale locale) {
        return this.tabbed ? new TabbedGroupEditor(this, locale) : new PanelGroupEditor(this, locale);
    }

    @Override
    @Nullable
    public String getName(@Nullable Locale locale) {
        return I18n.getString((String)this.nameTag, (Locale)locale);
    }

    @NotNull
    String getNameTag() {
        return this.nameTag;
    }

    Iterator<T> propertyIterator() {
        return this.propertyList.iterator();
    }

    public void addValueChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
        for (EditableProperty editableProperty : this.propertyList) {
            editableProperty.addValueChangeListener(propertyChangeListener);
        }
    }

    public void removeValueChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
        for (EditableProperty editableProperty : this.propertyList) {
            editableProperty.removeValueChangeListener(propertyChangeListener);
        }
    }

    public void addValueChangeListenerWeakly(@NotNull PropertyChangeListener propertyChangeListener) {
        for (EditableProperty editableProperty : this.propertyList) {
            editableProperty.addValueChangeListenerWeakly(propertyChangeListener);
        }
    }

    public void removeValueChangeListenerWeakly(@NotNull PropertyChangeListener propertyChangeListener) {
        for (EditableProperty editableProperty : this.propertyList) {
            editableProperty.removeValueChangeListenerWeakly(propertyChangeListener);
        }
    }

    protected void addProperty(@NotNull T t) {
        this.propertyList.add(t);
    }

    int getTabIndex() {
        return this.tabIndex;
    }

    void setTabIndex(int n) {
        this.tabIndex = n;
    }
}

