/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.util.settings.swing.AbstractBasicEditorProvider;
import de.caff.util.settings.swing.SwingDirectoryPreferenceProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;

class DirectoryEditor
extends AbstractBasicEditorProvider
implements PropertyChangeListener {
    private final SwingDirectoryPreferenceProperty property;
    private final Box box = Box.createHorizontalBox();
    private final JLabel label;
    private final JButton button;
    private File directory;

    public DirectoryEditor(SwingDirectoryPreferenceProperty swingDirectoryPreferenceProperty, Locale locale) {
        super(swingDirectoryPreferenceProperty, locale);
        this.property = swingDirectoryPreferenceProperty;
        this.directory = this.property.getDirectory();
        this.label = new JLabel(this.directory.getPath());
        this.button = new JButton("...");
        this.button.addActionListener(actionEvent -> {
            JFileChooser jFileChooser = new JFileChooser(this.directory);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle(this.property.getName(locale));
            if (jFileChooser.showSaveDialog(this.button) == 0) {
                this.setDirectory(jFileChooser.getSelectedFile());
            }
        });
        this.box.add(this.label);
        this.box.add(Box.createHorizontalGlue());
        this.box.add(this.button);
        this.property.addValueChangeListenerWeakly(this);
    }

    private void setDirectory(File file) {
        this.directory = file;
        this.label.setText(file == null ? "" : file.getPath());
    }

    @Override
    @NotNull
    public JComponent getEditor() {
        return this.box;
    }

    @Override
    public void reset() {
        this.setDirectory(this.property.getDirectory());
    }

    @Override
    public void save() {
        this.property.setDirectory(this.directory);
    }

    @Override
    public void goodBye() {
        this.property.removeValueChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirectory((File)propertyChangeEvent.getNewValue());
    }
}

