/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.i18n.swing.RJButton;
import de.caff.util.settings.swing.AbstractBasicEditorProvider;
import de.caff.util.settings.swing.SwingColorProperty;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;

public class ColorEditor
extends AbstractBasicEditorProvider
implements PropertyChangeListener {
    private static final int IMAGE_WIDTH = 32;
    private static final int IMAGE_HEIGHT = 16;
    private final SwingColorProperty property;
    private final JButton button;
    private Color color;

    public ColorEditor(@NotNull SwingColorProperty swingColorProperty, Locale locale) {
        this(swingColorProperty, locale, false);
    }

    public ColorEditor(@NotNull SwingColorProperty swingColorProperty, Locale locale, boolean bl) {
        super(swingColorProperty, locale);
        this.property = swingColorProperty;
        this.button = new RJButton("btChangeColor");
        this.button.setLocale(locale);
        this.button.addActionListener(actionEvent -> {
            Color color = JColorChooser.showDialog(this.button, this.property.getName(locale), this.color);
            if (color != null) {
                this.setColor(color);
                if (bl) {
                    this.save();
                }
            }
        });
        this.property.addValueChangeListenerWeakly(this);
        this.setColor(swingColorProperty.getValue());
    }

    private void setColor(Color color) {
        this.color = color;
        this.button.setIcon(ColorEditor.createColoredIcon(color));
    }

    static Icon createColoredIcon(Color color) {
        BufferedImage bufferedImage = new BufferedImage(32, 16, 1);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        graphics.setColor(color);
        graphics.fillRect(0, 0, 32, 16);
        graphics.dispose();
        return new ImageIcon(bufferedImage);
    }

    @Override
    @NotNull
    public JComponent getEditor() {
        return this.button;
    }

    @Override
    public void reset() {
        this.setColor(this.property.getValue());
    }

    @Override
    public void save() {
        this.property.setValue(this.color);
    }

    @Override
    public void goodBye() {
        this.property.removeValueChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.color.equals(propertyChangeEvent.getOldValue())) {
            this.setColor((Color)propertyChangeEvent.getNewValue());
        }
    }
}

