/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.util.settings.swing.AbstractBasicEditorProvider;
import de.caff.util.settings.swing.SwingBooleanProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

class BooleanEditor
extends AbstractBasicEditorProvider
implements PropertyChangeListener {
    private final SwingBooleanProperty property;
    private final JCheckBox checkBox;

    public BooleanEditor(@NotNull SwingBooleanProperty swingBooleanProperty, @Nullable Locale locale) {
        super(swingBooleanProperty, locale);
        this.property = swingBooleanProperty;
        this.checkBox = new JCheckBox((String)null, (boolean)swingBooleanProperty.getValue());
        if (swingBooleanProperty.isAutoSave()) {
            this.checkBox.addChangeListener(changeEvent -> this.save());
        }
        swingBooleanProperty.addValueChangeListenerWeakly(this);
    }

    @Override
    @NotNull
    public JComponent getEditor() {
        return this.checkBox;
    }

    @Override
    public void reset() {
        this.checkBox.setSelected(this.property.getValue());
    }

    @Override
    public void save() {
        this.property.setValue(this.checkBox.isSelected());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = (Boolean)propertyChangeEvent.getNewValue();
        if (bl != this.checkBox.isSelected()) {
            this.checkBox.setSelected(bl);
        }
    }

    @Override
    public void goodBye() {
        this.property.removeValueChangeListener(this);
    }
}

