/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.i18n.I18n;
import de.caff.util.settings.SettingsTools;
import de.caff.util.settings.swing.AbstractBasicSimpleEditableChangeableItem;
import de.caff.util.settings.swing.EditorProvider;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;

abstract class AbstractBasicEditorProvider
implements EditorProvider {
    private final String labelName;
    private final String toolTipText;
    private final String description;

    protected AbstractBasicEditorProvider(@NotNull String string, @Nullable Locale locale) {
        this.labelName = SettingsTools.getOptionalI18nString((String)(string + "-NAME[ACTION]"), (Locale)locale);
        this.toolTipText = SettingsTools.getOptionalI18nString((String)(string + "-TTT[ACTION]"), (Locale)locale);
        this.description = SettingsTools.getOptionalI18nString((String)(string + "-DESCR[ACTION]"), (Locale)locale);
    }

    protected AbstractBasicEditorProvider(@NotNull AbstractBasicSimpleEditableChangeableItem abstractBasicSimpleEditableChangeableItem, @Nullable Locale locale) {
        this(abstractBasicSimpleEditableChangeableItem.getBaseTag(), locale);
    }

    @Override
    public boolean isValidValue() {
        return true;
    }

    @Override
    @Nullable
    public String getLabelText() {
        return this.labelName;
    }

    @Nullable
    public static String getLabelTextWithPunctuation(@Nullable String string) {
        if (string == null) {
            return null;
        }
        String string2 = I18n.getString((String)"valueNamePunctuation");
        boolean bl = string2.indexOf(string.charAt(string.length() - 1)) >= 0;
        return I18n.format((String)(bl ? "valueNameFormatPunctuation" : "valueNameFormat"), (Object[])new Object[]{string, string.substring(0, string.length() - 1)});
    }

    @Override
    @Nullable
    public JComponent getLabel() {
        if (this.labelName == null) {
            return null;
        }
        return new JLabel(AbstractBasicEditorProvider.getLabelTextWithPunctuation(this.labelName));
    }

    @Override
    @Nullable
    public String getTitleText() {
        return null;
    }

    @Override
    @Nullable
    public String getToolTipText() {
        return this.toolTipText;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    static {
        I18n.addAppResourceBase((String)"de.caff.util.settings.swing.SettingsResourceBundle");
    }
}

