/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.annotation.NotNull;
import de.caff.generics.Empty;
import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.util.Utility;
import java.awt.Component;
import java.awt.Image;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;

public class RJTabbedPane
extends JTabbedPane
implements Localizable {
    private static final long serialVersionUID = -2406799170208381516L;
    private String[] baseTags = Empty.STRING_ARRAY;

    private void init() {
        super.setLocale(I18n.getDefaultLocale());
    }

    public RJTabbedPane() {
        super.setLocale(I18n.getDefaultLocale());
        this.init();
    }

    public RJTabbedPane(int n) {
        super(n);
        this.init();
    }

    public RJTabbedPane(int n, int n2) {
        super(n, n2);
        this.init();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener((Localizable)this);
    }

    @Override
    public void removeNotify() {
        I18n.removeLocalizationChangeListener((Localizable)this);
        super.removeNotify();
    }

    public void addResourcedTab(@NotNull String string, @NotNull Component component) {
        super.addTab(I18n.getString((String)(string + "-NAME[ACTION]")), component);
        this.updateBaseTagSize();
        int n = this.getTabCount() - 1;
        this.baseTags[n] = string;
        this.resetResources(n);
    }

    private void updateBaseTagSize() {
        String[] stringArray = new String[this.getTabCount()];
        System.arraycopy(this.baseTags, 0, stringArray, 0, Math.min(stringArray.length, this.baseTags.length));
        this.baseTags = stringArray;
    }

    private void resetResources(int n) {
        this.resetResources(n, this.getLocale());
    }

    private void resetResources(int n, Locale locale) {
        String string = this.baseTags[n];
        if (string != null) {
            Image image;
            super.setTitleAt(n, I18n.getString((String)(string + "-NAME[ACTION]"), (Locale)locale));
            try {
                this.setToolTipTextAt(n, I18n.getString((String)(string + "-TTT[ACTION]"), (Locale)locale));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                this.setMnemonicAt(n, I18n.getString((String)(string + "-MNEMO[ACTION]"), (Locale)locale).charAt(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                image = Utility.loadImage((String)I18n.getString((String)(string + "-ICON-DIS[ACTION]"), (Locale)locale));
                if (image != null) {
                    this.setDisabledIconAt(n, new ImageIcon(image));
                } else {
                    this.setDisabledIconAt(n, null);
                }
            }
            catch (MissingResourceException missingResourceException) {
                this.setDisabledIconAt(n, null);
            }
            try {
                image = Utility.loadImage((String)I18n.getString((String)(string + "-ICON[ACTION]"), (Locale)locale));
                if (image != null) {
                    this.setIconAt(n, new ImageIcon(image));
                } else {
                    this.setIconAt(n, null);
                }
            }
            catch (MissingResourceException missingResourceException) {
                this.setIconAt(n, null);
            }
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.updateBaseTagSize();
    }

    @Override
    public void remove(int n) {
        super.remove(n);
    }

    @Override
    public void removeTabAt(int n) {
        super.removeTabAt(n);
        System.arraycopy(this.baseTags, n + 1, this.baseTags, n, this.getTabCount() - n);
        this.updateBaseTagSize();
    }

    @Override
    public void remove(Component component) {
        super.remove(component);
    }

    @Override
    public void setTitleAt(int n, String string) {
        super.setTitleAt(n, string);
        this.baseTags[n] = null;
    }

    @Override
    public void setToolTipTextAt(int n, String string) {
        super.setToolTipTextAt(n, string);
        this.baseTags[n] = null;
    }

    @Override
    public void setDisabledIconAt(int n, Icon icon) {
        super.setDisabledIconAt(n, icon);
        this.baseTags[n] = null;
    }

    @Override
    public void setIconAt(int n, Icon icon) {
        super.setIconAt(n, icon);
        this.baseTags[n] = null;
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            this.resetResources(i, locale);
        }
    }
}

