/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.util.settings.IntegerPreferenceProperty;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Locale;
import javax.swing.JSplitPane;

public class RJSplitPane
extends JSplitPane
implements Localizable {
    private static final long serialVersionUID = -3904535612520147699L;

    public RJSplitPane() {
        super.setLocale(I18n.getDefaultLocale());
    }

    public RJSplitPane(int n) {
        super(n);
        super.setLocale(I18n.getDefaultLocale());
    }

    public RJSplitPane(int n, boolean bl) {
        super(n, bl);
        super.setLocale(I18n.getDefaultLocale());
    }

    public RJSplitPane(int n, Component component, Component component2) {
        super(n, component, component2);
        super.setLocale(I18n.getDefaultLocale());
    }

    public RJSplitPane(int n, boolean bl, Component component, Component component2) {
        super(n, bl, component, component2);
        super.setLocale(I18n.getDefaultLocale());
    }

    public RJSplitPane(Locale locale) {
        this.setLocale(locale);
    }

    public RJSplitPane(int n, Locale locale) {
        super(n);
        this.setLocale(locale);
    }

    public RJSplitPane(int n, boolean bl, Locale locale) {
        super(n, bl);
        this.setLocale(locale);
    }

    public RJSplitPane(int n, Component component, Component component2, Locale locale) {
        super(n, component, component2);
        this.setLocale(locale);
    }

    public RJSplitPane(int n, boolean bl, Component component, Component component2, Locale locale) {
        super(n, bl, component, component2);
        this.setLocale(locale);
    }

    public void setupPreferences(@Nullable IntegerPreferenceProperty integerPreferenceProperty, final int n) {
        if (integerPreferenceProperty == null) {
            return;
        }
        int n2 = (Integer)integerPreferenceProperty.getValue();
        if (n2 > 0) {
            this.setDividerLocation(n2);
        } else {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    if (componentEvent.getComponent().getWidth() > 32 || componentEvent.getComponent().getHeight() > 32) {
                        RJSplitPane.this.setDividerLocation(Math.min(RJSplitPane.this.getMaximumDividerLocation(), Math.max(RJSplitPane.this.getMinimumDividerLocation(), n)));
                        componentEvent.getComponent().removeComponentListener(this);
                    }
                }
            });
        }
        this.addPropertyChangeListener("dividerLocation", propertyChangeEvent -> integerPreferenceProperty.setValue((Object)((Integer)propertyChangeEvent.getNewValue())));
    }

    public void setupPreferences(@NotNull IntegerPreferenceProperty integerPreferenceProperty, final double d) {
        int n = (Integer)integerPreferenceProperty.getValue();
        if (n > 0) {
            this.setDividerLocation(n);
        } else {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    int n;
                    int n2 = n = RJSplitPane.this.getOrientation() == 1 ? RJSplitPane.this.getWidth() : RJSplitPane.this.getHeight();
                    if (n > 32) {
                        int n3 = (int)(d * (double)n);
                        RJSplitPane.this.setDividerLocation(Math.min(RJSplitPane.this.getMaximumDividerLocation(), Math.max(RJSplitPane.this.getMinimumDividerLocation(), n3)));
                        componentEvent.getComponent().removeComponentListener(this);
                    }
                }
            });
        }
        this.addPropertyChangeListener("dividerLocation", propertyChangeEvent -> integerPreferenceProperty.setValue((Object)((Integer)propertyChangeEvent.getNewValue())));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener((Localizable)this);
    }

    @Override
    public void removeNotify() {
        I18n.removeLocalizationChangeListener((Localizable)this);
        super.removeNotify();
    }

    @Override
    public void setLocale(Locale locale) {
        Locale locale2 = this.getLocale();
        super.setLocale(locale);
        if (locale2 != null && !locale2.equals(locale)) {
            this.invalidate();
        }
    }

    @Override
    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return null;
        }
    }
}

