/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.i18n.swing.I18nHelper;
import java.awt.IllegalComponentStateException;
import java.util.Locale;
import javax.swing.JMenuItem;

public class RJMenuItem
extends JMenuItem
implements Localizable {
    private static final long serialVersionUID = -4552009139480307014L;
    protected String resTag;

    public RJMenuItem(String string) {
        super.setLocale(I18n.getDefaultLocale());
        this.setTag(string);
    }

    public RJMenuItem(String string, Locale locale) {
        this.setTag(string, locale);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener((Localizable)this);
    }

    @Override
    public void removeNotify() {
        I18n.removeLocalizationChangeListener((Localizable)this);
        super.removeNotify();
    }

    public void setTag(String string) {
        this.setTag(string, this.getLocale());
    }

    public void setTag(String string, Locale locale) {
        this.resTag = string;
        this.setLocale(locale);
        I18nHelper.setProperties(this, this.resTag, locale);
    }

    @Override
    public void setLocale(Locale locale) {
        Locale locale2 = this.getLocale();
        super.setLocale(locale);
        if (locale2 != null && !locale2.equals(locale) && this.resTag != null) {
            I18nHelper.setProperties(this, this.resTag, locale);
        }
    }

    @Override
    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return null;
        }
    }
}

