/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import java.awt.IllegalComponentStateException;
import java.util.Locale;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public class RJMenuBar
extends JMenuBar
implements Localizable {
    private static final long serialVersionUID = 5319417106507540156L;

    public RJMenuBar(Locale locale) {
        this.setLocale(locale);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener((Localizable)this);
    }

    @Override
    public void removeNotify() {
        I18n.removeLocalizationChangeListener((Localizable)this);
        super.removeNotify();
    }

    @Override
    public void setLocale(Locale locale) {
        Locale locale2 = this.getLocale();
        super.setLocale(locale);
        if (locale2 != null && !locale2.equals(locale)) {
            for (int i = this.getMenuCount() - 1; i >= 0; --i) {
                JMenu jMenu = this.getMenu(i);
                if (!(jMenu instanceof Localizable)) continue;
                jMenu.setLocale(locale);
            }
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        for (int i = this.getMenuCount() - 1; i >= 0; --i) {
            JMenu jMenu = this.getMenu(i);
            jMenu.updateUI();
        }
    }

    @Override
    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return null;
        }
    }

    @Override
    public JMenu add(JMenu jMenu) {
        Localizable localizable;
        if (jMenu instanceof Localizable && (localizable = (Localizable)jMenu).getLocale() == null) {
            localizable.setLocale(this.getLocale());
        }
        return super.add(jMenu);
    }
}

