/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.annotation.NotNull;
import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.i18n.swing.I18nHelper;
import java.awt.IllegalComponentStateException;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class RJMenu
extends JMenu
implements Localizable {
    private static final long serialVersionUID = 6209438987013187485L;
    protected String resTag;

    public RJMenu(@NotNull String string) {
        this(string, false);
    }

    public RJMenu(@NotNull String string, boolean bl) {
        super("", bl);
        super.setLocale(I18n.getDefaultLocale());
        this.setTag(string);
    }

    public RJMenu(@NotNull String string, Action ... actionArray) {
        this(string, false, actionArray);
    }

    public RJMenu(@NotNull String string, boolean bl, Action ... actionArray) {
        super("", bl);
        super.setLocale(I18n.getDefaultLocale());
        this.setTag(string);
        for (Action action : actionArray) {
            if (action == null) {
                this.addSeparator();
                continue;
            }
            this.add(action);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener((Localizable)this);
    }

    @Override
    public void removeNotify() {
        I18n.removeLocalizationChangeListener((Localizable)this);
        super.removeNotify();
    }

    public void setTag(@NotNull String string) {
        this.resTag = string;
        I18nHelper.setProperties(this, string, this.getLocale());
    }

    @Override
    public void setLocale(Locale locale) {
        Locale locale2 = this.getLocale();
        super.setLocale(locale);
        if (locale2 != null && !locale2.equals(locale) && this.resTag != null) {
            I18nHelper.setProperties(this, this.resTag, this.getLocale());
        }
    }

    @Override
    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return null;
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        for (int i = this.getItemCount() - 1; i >= 0; --i) {
            JMenuItem jMenuItem = this.getItem(i);
            if (jMenuItem == null) continue;
            jMenuItem.updateUI();
        }
    }

    @Override
    public JMenuItem add(@NotNull JMenuItem jMenuItem) {
        Localizable localizable;
        if (jMenuItem instanceof Localizable && (localizable = (Localizable)jMenuItem).getLocale() == null) {
            localizable.setLocale(this.getLocale());
        }
        return super.add(jMenuItem);
    }

    @Override
    public JMenuItem insert(@NotNull JMenuItem jMenuItem, int n) {
        Localizable localizable;
        if (jMenuItem instanceof Localizable && (localizable = (Localizable)jMenuItem).getLocale() == null) {
            localizable.setLocale(this.getLocale());
        }
        return super.insert(jMenuItem, n);
    }
}

