/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.i18n.swing.I18nHelper;
import java.awt.IllegalComponentStateException;
import java.util.Locale;
import javax.swing.JLabel;

public class RJLabel
extends JLabel
implements Localizable {
    private static final long serialVersionUID = -8023534734652838087L;
    protected String textResource;
    protected String addText;

    private void init(@NotNull String string, @Nullable String string2) {
        super.setLocale(I18n.getDefaultLocale());
        I18nHelper.setProperties(this, string, this.getLocale());
        if (string2 != null) {
            this.setText(this.getText() + string2);
        }
        this.textResource = string;
        this.addText = string2;
    }

    public RJLabel(@NotNull String string) {
        this.init(string, null);
    }

    public RJLabel(@NotNull String string, int n) {
        this.init(string, null);
        this.setHorizontalAlignment(n);
    }

    public RJLabel(@NotNull String string, String string2) {
        this.init(string, string2);
    }

    public RJLabel(@NotNull String string, String string2, int n) {
        this.init(string, string2);
        this.setHorizontalAlignment(n);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener((Localizable)this);
    }

    @Override
    public void removeNotify() {
        I18n.removeLocalizationChangeListener((Localizable)this);
        super.removeNotify();
    }

    @Override
    public void setLocale(Locale locale) {
        Locale locale2 = this.getLocale();
        super.setLocale(locale);
        if (locale2 != null && !locale2.equals(locale) && this.textResource != null) {
            I18nHelper.setProperties(this, this.textResource, this.getLocale());
            if (this.addText != null) {
                this.setText(this.getText() + this.addText);
            }
            this.invalidate();
        }
    }

    @Override
    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return null;
        }
    }
}

