/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.util.settings.BoundsPreferenceProperty;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Locale;
import javax.swing.JFrame;

public class RJFrame
extends JFrame
implements Localizable {
    private static final long serialVersionUID = 4970577955076794806L;
    protected String titleRes = null;

    public RJFrame() {
        super.setLocale(I18n.getDefaultLocale());
    }

    public RJFrame(String string, Locale locale) {
        super(I18n.getString((String)string, (Locale)locale));
        this.setLocale(locale);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener((Localizable)this);
    }

    @Override
    public void removeNotify() {
        I18n.removeLocalizationChangeListener((Localizable)this);
        super.removeNotify();
    }

    public void setTitleTag(String string) {
        this.titleRes = string;
        if (string != null) {
            this.setTitle(I18n.getString((String)string, (Locale)this.getLocale()));
        }
    }

    @Override
    public void setLocale(Locale locale) {
        Locale locale2 = this.getLocale();
        super.setLocale(locale);
        if (locale2 != null && !locale2.equals(locale) && this.titleRes != null) {
            this.setTitle(I18n.getString((String)this.titleRes, (Locale)locale));
        }
    }

    @Override
    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return null;
        }
    }

    public void setupPreferences(final @NotNull BoundsPreferenceProperty boundsPreferenceProperty, @Nullable Dimension dimension) {
        if (!boundsPreferenceProperty.setWindowBounds((Window)this)) {
            if (dimension == null) {
                Toolkit toolkit = this.getToolkit();
                Dimension dimension2 = toolkit.getScreenSize();
                Insets insets = toolkit.getScreenInsets(this.getGraphicsConfiguration());
                this.setBounds(insets.left, insets.top, dimension2.width - insets.left - insets.right, dimension2.height - insets.top - insets.bottom);
            } else {
                this.setSize(dimension);
            }
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                boundsPreferenceProperty.setBounds((Window)RJFrame.this);
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                boundsPreferenceProperty.setBounds((Window)RJFrame.this);
            }
        });
    }
}

