/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.generics.Empty;
import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.util.Locale;
import javax.swing.JComboBox;

public class RJComboBox
extends JComboBox
implements Localizable {
    private static final long serialVersionUID = 6097292415335683297L;
    protected boolean localeUnknown = true;
    protected String[] resTags = Empty.STRING_ARRAY;

    public RJComboBox() {
        super.setLocale(I18n.getDefaultLocale());
        this.setEditable(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener((Localizable)this);
    }

    @Override
    public void removeNotify() {
        I18n.removeLocalizationChangeListener((Localizable)this);
        super.removeNotify();
    }

    public void add(String string) {
        this.addItemTag(string);
    }

    public void addItemTag(String string) {
        super.addItem(I18n.getString((String)string, (Locale)this.getLocale()));
        String[] stringArray = new String[this.resTags.length + 1];
        if (this.resTags.length > 0) {
            System.arraycopy(this.resTags, 0, stringArray, 0, this.resTags.length);
        }
        stringArray[this.resTags.length] = string;
        this.resTags = stringArray;
    }

    public String getTag(int n) {
        return this.resTags[n];
    }

    public String getSelectedTag() {
        return this.resTags[this.getSelectedIndex()];
    }

    public void insertItemAt(String string, int n) {
        super.insertItemAt(I18n.getString((String)string, (Locale)this.getLocale()), n);
        String[] stringArray = new String[this.resTags.length + 1];
        if (n > 0) {
            System.arraycopy(this.resTags, 0, stringArray, 0, n);
        }
        stringArray[n] = string;
        if (n < this.resTags.length) {
            System.arraycopy(this.resTags, n, stringArray, n + 1, this.resTags.length - n);
        }
        this.resTags = stringArray;
    }

    @Override
    public void remove(int n) {
        super.remove(n);
        String[] stringArray = new String[this.resTags.length - 1];
        if (n > 0) {
            System.arraycopy(this.resTags, 0, stringArray, 0, n);
        }
        if (n < this.resTags.length - 1) {
            System.arraycopy(this.resTags, n + 1, stringArray, n, this.resTags.length - n - 1);
        }
        this.resTags = stringArray;
    }

    public void remove(String string) {
        for (int i = 0; i < this.resTags.length; ++i) {
            if (!this.resTags[i].equals(string)) continue;
            this.remove(i);
            return;
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.resTags = Empty.STRING_ARRAY;
    }

    public void setSelectedIndex(String string) {
        for (int i = 0; i < this.resTags.length; ++i) {
            if (!this.resTags[i].equals(string)) continue;
            this.setSelectedIndex(i);
            return;
        }
    }

    @Override
    public void setLocale(Locale locale) {
        Locale locale2 = this.getLocale();
        super.setLocale(locale);
        if (locale2 != null && !locale2.equals(locale)) {
            int n = this.getSelectedIndex();
            super.removeAll();
            for (String string : this.resTags) {
                super.addItem(I18n.getString((String)string, (Locale)this.getLocale()));
            }
            this.setSelectedIndex(n);
            this.invalidate();
        }
    }

    @Override
    public Locale getLocale() {
        try {
            this.localeUnknown = false;
            return super.getLocale();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            this.localeUnknown = true;
            return null;
        }
    }

    @Override
    public void update(Graphics graphics) {
        if (this.localeUnknown) {
            this.setLocale(this.getLocale());
        } else {
            super.update(graphics);
        }
    }
}

