/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.i18n.swing.I18nHelper;
import java.awt.IllegalComponentStateException;
import java.util.Locale;
import javax.swing.JCheckBoxMenuItem;

public class RJCheckBoxMenuItem
extends JCheckBoxMenuItem
implements Localizable {
    private static final long serialVersionUID = -655555423098270302L;
    protected String resTag;

    public RJCheckBoxMenuItem(boolean bl) {
        super("", bl);
        this.setLocale(I18n.getDefaultLocale());
    }

    public RJCheckBoxMenuItem(String string, boolean bl) {
        super("", bl);
        this.setLocale(I18n.getDefaultLocale());
        this.setTag(string);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener((Localizable)this);
    }

    @Override
    public void removeNotify() {
        I18n.removeLocalizationChangeListener((Localizable)this);
        super.removeNotify();
    }

    public void setTag(String string) {
        this.resTag = string;
        I18nHelper.setProperties(this, this.resTag, this.getLocale());
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = I18n.getDefaultLocale();
        }
        Locale locale2 = this.getLocale();
        super.setLocale(locale);
        if (locale2 != null && !locale2.equals(locale) && this.resTag != null) {
            I18nHelper.setProperties(this, this.resTag, locale);
        }
    }

    @Override
    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return null;
        }
    }
}

