/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.i18n.swing.I18nHelper;
import java.awt.IllegalComponentStateException;
import java.util.Locale;
import javax.swing.JButton;

public class RJButton
extends JButton
implements Localizable {
    private static final long serialVersionUID = -7937411737061904897L;
    protected String resTag;

    public RJButton(String string) {
        super.setLocale(I18n.getDefaultLocale());
        this.setTag(string);
    }

    protected void setTag(String string) {
        this.resTag = string;
        I18nHelper.setProperties(this, string, this.getLocale());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener((Localizable)this);
    }

    @Override
    public void removeNotify() {
        I18n.removeLocalizationChangeListener((Localizable)this);
        super.removeNotify();
    }

    @Override
    public void setLocale(Locale locale) {
        Locale locale2 = this.getLocale();
        super.setLocale(locale);
        if (locale2 != null && !locale2.equals(locale) && this.resTag != null) {
            this.setTag(this.resTag);
            this.invalidate();
        }
    }

    @Override
    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return null;
        }
    }
}

