/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.i18n.I18n;
import de.caff.util.swing.SwingHelper;
import de.caff.vic.RecolorableIcon;
import de.caff.vic.RecoloringVisitor;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class I18nHelper {
    public static void setProperties(@NotNull JMenuItem jMenuItem, @NotNull String string, @Nullable Locale locale) {
        I18nHelper.setProperties((AbstractButton)jMenuItem, string, locale);
        try {
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(I18n.getString((String)(string + "-ACCEL[ACTION]"), (Locale)locale)));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public static void setProperties(@NotNull AbstractButton abstractButton, @NotNull String string, @Nullable Locale locale) {
        Icon icon;
        abstractButton.setText(I18n.getString((String)(string + "-NAME[ACTION]"), (Locale)locale));
        try {
            abstractButton.setToolTipText(I18n.getString((String)(string + "-TTT[ACTION]"), (Locale)locale));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            abstractButton.setMnemonic(I18n.getString((String)(string + "-MNEMO[ACTION]"), (Locale)locale).charAt(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            icon = SwingHelper.loadIconResource(I18n.getString((String)(string + "-ICON[ACTION]"), (Locale)locale));
            if (icon != null) {
                abstractButton.setIcon(icon);
                if (icon instanceof RecolorableIcon) {
                    abstractButton.setDisabledIcon((Icon)((RecolorableIcon)icon).getRecoloredIcon(RecoloringVisitor.TO_LIGHTER_GRAY));
                }
            } else {
                abstractButton.setIcon(null);
            }
        }
        catch (MissingResourceException missingResourceException) {
            abstractButton.setIcon(null);
        }
        try {
            icon = SwingHelper.loadIconResource(I18n.getString((String)(string + "-ICON-DIS[ACTION]"), (Locale)locale));
            if (icon != null) {
                abstractButton.setDisabledIcon(icon);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public static void setProperties(@NotNull JLabel jLabel, @NotNull String string, @Nullable Locale locale) {
        jLabel.setText(I18n.getString((String)(string + "-NAME[ACTION]"), (Locale)locale));
        try {
            jLabel.setToolTipText(I18n.getString((String)(string + "-TTT[ACTION]"), (Locale)locale));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

