/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.annotation.NotNull;
import de.caff.gimmicks.swing.AbstractState;
import de.caff.gimmicks.swing.ResourcedAction;
import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.i18n.WeakReferencedLocalizable;
import de.caff.util.swing.SwingHelper;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.Icon;

public abstract class VisibleState
extends AbstractState
implements Localizable {
    private static final String LABEL_RESOURCE_KEY_PROPERTY = "LABEL_RESOURCE_KEY";
    private static final String TOOLTIP_RESOURCE_KEY_PROPERTY = "TOOLTIP_RESOURCE_KEY";
    private Locale locale;

    public VisibleState(String string, String string2, Icon icon, Icon icon2, Icon icon3) {
        this.init(string, string2, icon, icon2, icon3);
    }

    public VisibleState() {
    }

    private void init(String string, String string2, Icon icon, Icon icon2, Icon icon3) {
        this.setProperty(LABEL_RESOURCE_KEY_PROPERTY, string);
        this.setProperty(TOOLTIP_RESOURCE_KEY_PROPERTY, string2);
        this.setProperty("ACTIVE_ICON", icon);
        this.setProperty("INACTIVE_ICON", icon2);
        this.setProperty("DISABLED_ICON", icon3);
        I18n.addLocalizationChangeListener((Localizable)new WeakReferencedLocalizable((Localizable)this));
        this.setLocale(I18n.getDefaultLocale());
    }

    public VisibleState(String string, String string2, Icon icon) {
        this(string, string2, icon, icon, null);
    }

    public VisibleState(@NotNull String string) {
        Icon icon = SwingHelper.loadIconResource(I18n.getString((String)(string + "-ICON[ACTION]")));
        Icon icon2 = null;
        Icon icon3 = icon;
        try {
            icon3 = SwingHelper.loadIconResource(I18n.getString((String)(string + "-ICON-INACT[ACTION]")));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            icon2 = SwingHelper.loadIconResource(I18n.getString((String)(string + "-ICON-DIS[ACTION]")));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.init(string + "-NAME[ACTION]", string + "-TTT[ACTION]", icon, icon3, icon2);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        Object object = this.getValue(LABEL_RESOURCE_KEY_PROPERTY);
        if (object != null) {
            this.setProperty("LABEL_TEXT", I18n.getString((String)object.toString(), (Locale)locale));
        }
        object = this.getValue(TOOLTIP_RESOURCE_KEY_PROPERTY);
        if (ResourcedAction.I18N_DEBUG) {
            if (object == null) {
                object = this.getValue(LABEL_RESOURCE_KEY_PROPERTY);
                if (object != null) {
                    String string = object.toString();
                    if (string.endsWith("-NAME[ACTION]")) {
                        string = string.substring(0, string.length() - "-NAME[ACTION]".length());
                    }
                    this.setProperty("TOOLTIP_TEXT", String.format("[%s]", string));
                }
            } else {
                String string = object.toString();
                String string2 = I18n.getString((String)string, (Locale)locale);
                if (string.endsWith("-TTT[ACTION]")) {
                    string = string.substring(0, string.length() - "-TTT[ACTION]".length());
                }
                this.setProperty("TOOLTIP_TEXT", String.format("%s [%s]", string2, string));
            }
        } else if (object != null) {
            this.setProperty("TOOLTIP_TEXT", I18n.getString((String)object.toString(), (Locale)locale));
        }
    }

    public Locale getLocale() {
        return this.locale;
    }
}

