/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;

public class UrlTextField
extends JFormattedTextField {
    private static final long serialVersionUID = 8442238956811768503L;

    public UrlTextField(boolean bl) {
        super(new UrlFormatter(bl));
    }

    public UrlTextField(@NotNull URL uRL) {
        super(new UrlFormatter(false));
        this.setValue(uRL);
    }

    public UrlTextField(@Nullable URL uRL, boolean bl) {
        super(new UrlFormatter(bl));
        this.setValue(uRL);
    }

    public static class UrlFormatter
    extends DefaultFormatter {
        private static final long serialVersionUID = -3934259494506014047L;
        private final boolean allowEmpty;

        public UrlFormatter(boolean bl) {
            this.allowEmpty = bl;
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            if (string == null || string.isEmpty()) {
                if (this.allowEmpty) {
                    return null;
                }
                throw new ParseException("URL is empty!", 0);
            }
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ParseException(string, 0);
            }
        }

        @Override
        public String valueToString(Object object) throws ParseException {
            if (object == null) {
                if (this.allowEmpty) {
                    return "";
                }
                throw new ParseException("Null value not allowed!", 0);
            }
            return object.toString();
        }

        @Override
        public UrlFormatter clone() throws CloneNotSupportedException {
            return (UrlFormatter)super.clone();
        }
    }
}

