/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.annotation.Nullable;
import java.awt.Graphics;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JToggleButton;

public class TriStateCheckBox
extends JCheckBox {
    private static final long serialVersionUID = -6279916149289195607L;
    private Icon partialIcon;
    private Icon unselectedIcon;
    private Icon selectedIcon;

    public TriStateCheckBox() {
        this(null, null, false);
    }

    public TriStateCheckBox(Icon icon) {
        this(null, icon, false);
    }

    public TriStateCheckBox(Icon icon, boolean bl) {
        this(null, icon, bl);
    }

    public TriStateCheckBox(String string) {
        this(string, null, false);
    }

    public TriStateCheckBox(Action action) {
        this.setModel(new TriStateCheckBoxModel());
        this.setAction(action);
    }

    public TriStateCheckBox(String string, boolean bl) {
        this(string, null, bl);
    }

    public TriStateCheckBox(String string, Icon icon) {
        this(string, icon, false);
    }

    public TriStateCheckBox(String string, Icon icon, boolean bl) {
        this.setModel(new TriStateCheckBoxModel());
        this.model.setSelected(bl);
        this.init(string, icon);
    }

    public void setTriState(@Nullable Boolean bl) {
        if (bl == null) {
            ((TriStateCheckBoxModel)this.getModel()).setPartiallySelected(true);
            if (this.partialIcon != null) {
                this.setSelectedIcon(this.partialIcon);
                this.setIcon(this.partialIcon);
            }
        } else {
            this.setIcon(this.unselectedIcon);
            this.setSelectedIcon(this.selectedIcon);
            this.setSelected(bl);
        }
    }

    public void setIcons(Icon icon, Icon icon2, Icon icon3) {
        this.unselectedIcon = icon;
        this.selectedIcon = icon2;
        this.partialIcon = icon3;
        this.setTriState(this.isPartiallySelected() ? null : Boolean.valueOf(this.isSelected()));
    }

    public boolean isPartiallySelected() {
        return ((TriStateCheckBoxModel)this.getModel()).isPartiallySelected();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    private static class TriStateCheckBoxModel
    extends JToggleButton.ToggleButtonModel {
        private static final long serialVersionUID = 163885317429832053L;
        private boolean partiallySelected;

        private TriStateCheckBoxModel() {
        }

        public void setPartiallySelected(boolean bl) {
            if (this.partiallySelected != bl) {
                this.partiallySelected = bl;
                super.setSelected(false);
            }
        }

        @Override
        public void setSelected(boolean bl) {
            this.partiallySelected = false;
            super.setSelected(bl);
        }

        @Override
        public boolean isArmed() {
            return this.partiallySelected || super.isArmed();
        }

        @Override
        public boolean isPressed() {
            return this.partiallySelected || super.isPressed();
        }

        public boolean isPartiallySelected() {
            return this.partiallySelected;
        }
    }
}

