/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeHelper {
    @NotNull
    public static TreePath nodeToPath(@NotNull TreeNode treeNode) {
        LinkedList<TreeNode> linkedList = new LinkedList<TreeNode>();
        while (treeNode != null) {
            linkedList.addFirst(treeNode);
            treeNode = treeNode.getParent();
        }
        return new TreePath(linkedList.toArray());
    }

    @Nullable
    public static TreeNode getNextMatch(@NotNull TreeModel treeModel, @Nullable TreeNode treeNode, @NotNull Predicate<TreeNode> predicate) {
        TreeNode treeNode2;
        TreeNode treeNode3 = treeNode2 = treeNode == null ? (TreeNode)treeModel.getRoot() : TreeHelper.nextNode(treeNode);
        while (treeNode2 != null) {
            if (predicate.test(treeNode2)) {
                return treeNode2;
            }
            treeNode2 = TreeHelper.nextNode(treeNode2);
        }
        return null;
    }

    @Nullable
    public static TreeNode getNextMatchCycling(@NotNull TreeModel treeModel, @Nullable TreeNode treeNode, @NotNull Predicate<TreeNode> predicate) {
        TreeNode treeNode2 = TreeHelper.getNextMatch(treeModel, treeNode, predicate);
        if (treeNode != null && treeNode2 == null) {
            return TreeHelper.getNextMatch(treeModel, null, predicate);
        }
        return treeNode2;
    }

    @Nullable
    public static TreeNode nextNode(@NotNull TreeNode treeNode) {
        return TreeHelper.nextNode(treeNode, true);
    }

    @Nullable
    private static TreeNode nextNode(@NotNull TreeNode treeNode, boolean bl) {
        if (bl && treeNode.getAllowsChildren() && treeNode.getChildCount() > 0) {
            return treeNode.getChildAt(0);
        }
        TreeNode treeNode2 = treeNode.getParent();
        if (treeNode2 == null) {
            return null;
        }
        int n = treeNode2.getChildCount();
        int n2 = treeNode2.getIndex(treeNode);
        if (n2 < n - 1) {
            return treeNode2.getChildAt(n2 + 1);
        }
        return TreeHelper.nextNode(treeNode2, false);
    }

    @NotNull
    public static Collection<TreeNode> getMatches(@NotNull TreeModel treeModel, @NotNull Predicate<TreeNode> predicate) {
        TreeNode treeNode = (TreeNode)treeModel.getRoot();
        LinkedList<TreeNode> linkedList = new LinkedList<TreeNode>();
        while (treeNode != null) {
            if (predicate.test(treeNode)) {
                linkedList.add(treeNode);
            }
            treeNode = TreeHelper.nextNode(treeNode);
        }
        return linkedList;
    }

    public static void traverse(@NotNull TreeModel treeModel, @NotNull Consumer<TreePath> consumer) {
        Object object = treeModel.getRoot();
        if (object != null) {
            TreeHelper.traverse(new TreePath(object), consumer);
        }
    }

    public static void traverse(@NotNull TreePath treePath, @NotNull Consumer<TreePath> consumer) {
        consumer.accept(treePath);
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreeHelper.traverse(treePath.pathByAddingChild(treeNode2), consumer);
            }
        }
    }

    public static boolean isDisplayed(@NotNull JTree jTree, TreePath treePath) {
        return jTree.isVisible(treePath) && jTree.getVisibleRect().intersects(jTree.getRowBounds(jTree.getRowForPath(treePath)));
    }

    public static boolean pathStartsWith(@NotNull TreePath treePath, @NotNull TreePath treePath2) {
        if (treePath.getPathCount() < treePath2.getPathCount()) {
            return false;
        }
        Object[] objectArray = treePath.getPath();
        Object[] objectArray2 = Arrays.copyOf(treePath.getPath(), objectArray.length);
        return Arrays.equals(objectArray, objectArray2);
    }
}

