/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.gimmicks.swing.AbstractState;
import de.caff.gimmicks.swing.State;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class StateManager
implements PropertyChangeListener {
    private final List<State> stateList = new LinkedList<State>();
    private State activeState;
    private boolean haveToggleStates = false;
    private boolean ignoringChanges;

    public void addState(@NotNull State state) {
        state.setManager(this);
        this.stateList.add(state);
        state.addPropertyChangeListener(this);
        if (!state.isToggleEnabled() && this.activeState == null) {
            state.activate();
            this.activeState = state;
        } else if (state.isActivated()) {
            this.setActiveState(state);
        }
        this.haveToggleStates |= state.isToggleEnabled();
    }

    void setActiveState(@Nullable State state) {
        if (this.activeState != state) {
            if (this.stateList.contains(state) || state == null && this.haveToggleStates) {
                if (this.activeState != null) {
                    this.activeState.deactivate();
                }
                this.activeState = state;
            } else {
                throw new RuntimeException("Trying to activate unregistered state");
            }
        }
    }

    @NotNull
    public List<State> getStates() {
        return Collections.unmodifiableList(this.stateList);
    }

    @Nullable
    public State getActiveState() {
        return this.activeState;
    }

    boolean mayActivate(@NotNull AbstractState abstractState) {
        if (this.stateList.contains(abstractState)) {
            return abstractState.isEnabled();
        }
        throw new RuntimeException("Trying to access unregistered state");
    }

    boolean mayEnable(AbstractState abstractState, boolean bl) {
        return bl || this.getFirstEnabledState(abstractState) != null;
    }

    protected State getFirstEnabledState(AbstractState abstractState) {
        for (State state : this.stateList) {
            if (state == abstractState || !state.isEnabled()) continue;
            return state;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.ignoringChanges) {
            return;
        }
        AbstractState abstractState = (AbstractState)propertyChangeEvent.getSource();
        if ("ACTIVATION".equals(propertyChangeEvent.getPropertyName())) {
            if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                this.setActiveState(abstractState);
            } else if (this.haveToggleStates && abstractState == this.activeState) {
                this.setActiveState(null);
            }
        } else if ("ENABLE".equals(propertyChangeEvent.getPropertyName()) && !((Boolean)propertyChangeEvent.getNewValue()).booleanValue() && this.activeState == abstractState && !this.haveToggleStates) {
            this.getFirstEnabledState(abstractState).activate();
        }
    }

    public boolean isIgnoringChanges() {
        return this.ignoringChanges;
    }

    public void setIgnoringChanges(boolean bl) {
        this.ignoringChanges = bl;
    }
}

