/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.gimmicks.swing.State;
import de.caff.util.Utility;
import de.caff.vic.RecolorableIcon;
import de.caff.vic.RecoloringVisitor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JToggleButton;

public class StateButton
extends JToggleButton
implements PropertyChangeListener,
ItemListener {
    private static final long serialVersionUID = 6719512758299692925L;
    private final State state;

    public StateButton(final State state) {
        Object object;
        this.setModel(new JToggleButton.ToggleButtonModel(){
            private static final long serialVersionUID = 3697751640306107911L;

            @Override
            public void setPressed(boolean bl) {
                if (!state.isActivated() || bl) {
                    super.setPressed(bl);
                } else if (state.isToggleEnabled()) {
                    super.setPressed(bl);
                }
            }
        });
        this.state = state;
        Icon icon = (Icon)state.getValue("INACTIVE_ICON");
        if (icon != null) {
            Icon icon2;
            this.setIcon(icon);
            object = (Icon)state.getValue("ACTIVE_ICON");
            if (object != null) {
                this.setSelectedIcon((Icon)object);
            }
            if ((icon2 = (Icon)state.getValue("DISABLED_ICON")) != null) {
                this.setDisabledIcon(icon2);
                this.setDisabledSelectedIcon(icon2);
            } else {
                if (icon instanceof RecolorableIcon) {
                    RecolorableIcon recolorableIcon = ((RecolorableIcon)icon).getRecoloredIcon(RecoloringVisitor.TO_LIGHTER_GRAY);
                    this.setDisabledIcon((Icon)recolorableIcon);
                    if (object == null) {
                        this.setDisabledSelectedIcon((Icon)recolorableIcon);
                    }
                }
                if (object instanceof RecolorableIcon) {
                    this.setDisabledSelectedIcon((Icon)((RecolorableIcon)object).getRecoloredIcon(RecoloringVisitor.TO_LIGHTER_GRAY));
                }
            }
        } else {
            this.setText((String)state.getValue("LABEL_TEXT"));
        }
        object = (String)state.getValue("TOOLTIP_TEXT");
        if (object != null) {
            this.setToolTipText((String)object);
        }
        this.setEnabled(state.isEnabled());
        this.setSelected(state.isActivated());
        this.addItemListener(this);
        state.addPropertyChangeListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (state.isActivated() && mouseEvent.isPopupTrigger()) {
                    state.showPopup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("ACTIVATION".equals(string)) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl != this.isSelected()) {
                this.setSelected(bl);
            }
        } else if ("ENABLE".equals(string)) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl != this.isEnabled()) {
                this.setEnabled(bl);
            }
        } else if ("ACTIVE_ICON".equals(string)) {
            Icon icon = (Icon)propertyChangeEvent.getNewValue();
            if (!icon.equals(this.getSelectedIcon())) {
                this.setSelectedIcon(icon);
            }
        } else if ("DISABLED_ICON".equals(string)) {
            Icon icon = (Icon)propertyChangeEvent.getNewValue();
            if (!icon.equals(this.getDisabledIcon())) {
                this.setDisabledIcon(icon);
                this.setDisabledSelectedIcon(icon);
            }
        } else if ("INACTIVE_ICON".equals(string)) {
            Icon icon = (Icon)propertyChangeEvent.getNewValue();
            if (!icon.equals(this.getIcon())) {
                this.setIcon(icon);
            }
        } else if ("LABEL_TEXT".equals(string)) {
            String string2 = (String)propertyChangeEvent.getNewValue();
            if (this.getIcon() == null) {
                this.setText(string2);
            }
        } else if ("TOOLTIP_TEXT".equals(string)) {
            String string3 = (String)propertyChangeEvent.getNewValue();
            this.setToolTipText(string3);
        } else if ("de.caff.gimmicks.swing.State.POPUP".equals(string)) {
            this.repaint();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.state.activate();
        } else {
            this.state.deactivate();
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.isEnabled() && this.isSelected() && this.state.hasPopup()) {
            Dimension dimension = this.getSize();
            Graphics2D graphics2D = (Graphics2D)graphics;
            StateButton.paintPopupIndicator(graphics2D, this.getBackground(), dimension);
        }
    }

    public static void paintPopupIndicator(Graphics2D graphics2D, Color color, Dimension dimension) {
        if (dimension.width < 8 || dimension.height < 8) {
            return;
        }
        Color color2 = Utility.getPhysiologicalBrightness((Color)color) >= 0.5f ? Color.black : Color.white;
        graphics2D.setColor(new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), 128));
        GeneralPath generalPath = new GeneralPath();
        float f = 0.25f * (float)Math.min(dimension.width, dimension.height) - 1.0f;
        generalPath.moveTo(dimension.width - 3, dimension.height - 3);
        generalPath.lineTo(dimension.width - 3, (float)(dimension.height - 3) - f);
        generalPath.lineTo((float)(dimension.width - 3) - f, dimension.height - 3);
        generalPath.closePath();
        graphics2D.fill(generalPath);
    }
}

