/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.annotation.NotNull;
import de.caff.i18n.I18n;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class SimpleFileExtensionFilter
extends FileFilter {
    @NotNull
    private final String description;
    @NotNull
    private final String extension;
    private boolean allowDirectories = true;

    public SimpleFileExtensionFilter(@NotNull String string) {
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        this.extension = string.toUpperCase();
        this.description = I18n.format((String)"nmFileFilter", (Object[])new Object[]{this.extension.substring(1)});
    }

    public SimpleFileExtensionFilter(@NotNull String string, @NotNull String string2) {
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        this.extension = string.toUpperCase();
        this.description = string2;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return this.allowDirectories;
        }
        return file.getName().toUpperCase().endsWith(this.extension);
    }

    public boolean isAllowDirectories() {
        return this.allowDirectories;
    }

    public void setAllowDirectories(boolean bl) {
        this.allowDirectories = bl;
    }

    @NotNull
    public String getFixedPath(@NotNull File file) {
        String string = file.getPath();
        if (!file.exists() && !string.toUpperCase().endsWith(this.extension)) {
            string = string + this.extension.toLowerCase();
        }
        return string;
    }

    @NotNull
    public File getFixedFilePath(@NotNull File file) {
        String string = file.getPath();
        if (!file.exists() && !string.toUpperCase().endsWith(this.extension)) {
            return new File(string + this.extension.toLowerCase());
        }
        return file;
    }

    static {
        I18n.addAppResourceBase((String)"de.caff.gimmicks.swing.GimmicksSwingResourceBundle");
    }
}

