/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.annotation.NotNull;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;

public class RotatedLabelUI
extends BasicLabelUI {
    private static final double ROTATION_ANGLE = 1.5707963267948966;
    private final boolean counterClockWise;
    @NotNull
    private final Rectangle paintIconR = new Rectangle();
    @NotNull
    private final Rectangle paintTextR = new Rectangle();
    private static final int HORIZONTAL_MARGIN = 0;
    private static final int VERTICAL_MARGIN = 3;

    public RotatedLabelUI(boolean bl) {
        this.counterClockWise = bl;
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        return super.getBaseline(jComponent, n, n2);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        return new Dimension(dimension.height + 0, dimension.width + 6);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = super.getMinimumSize(jComponent);
        return new Dimension(dimension.height + 0, dimension.width + 6);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = super.getMaximumSize(jComponent);
        return new Dimension(dimension.height + 0, dimension.width + 6);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Icon icon;
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        Icon icon2 = icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        if (icon == null && string == null) {
            return;
        }
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        String string2 = this.layout(jLabel, fontMetrics, jComponent.getHeight(), jComponent.getWidth());
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n = jComponent.getWidth() / 2;
        int n2 = jComponent.getHeight() / 2;
        graphics2D.translate(n, n2);
        if (this.counterClockWise) {
            graphics2D.rotate(-1.5707963267948966);
        } else {
            graphics2D.rotate(1.5707963267948966);
        }
        graphics2D.translate(-n2 + 3, -n);
        if (icon != null) {
            icon.paintIcon(jComponent, graphics2D, this.paintIconR.x, this.paintIconR.y);
        }
        if (string != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, this.paintTextR);
            } else {
                int n3 = this.paintTextR.x;
                int n4 = this.paintTextR.y + fontMetrics.getAscent();
                if (jLabel.isEnabled()) {
                    this.paintEnabledText(jLabel, graphics2D, string2, n3, n4);
                } else {
                    this.paintDisabledText(jLabel, graphics2D, string2, n3, n4);
                }
            }
        }
    }

    private String layout(JLabel jLabel, FontMetrics fontMetrics, int n, int n2) {
        Insets insets = jLabel.getInsets(null);
        String string = jLabel.getText();
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        Rectangle rectangle = new Rectangle();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = n - (insets.left + insets.right);
        rectangle.height = n2 - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        return this.layoutCL(jLabel, fontMetrics, string, icon, rectangle, this.paintIconR, this.paintTextR);
    }
}

