/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.i18n.WeakReferencedLocalizable;
import de.caff.util.Utility;
import de.caff.util.swing.SwingHelper;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class ResourcedAction
extends AbstractAction
implements Localizable {
    private static final long serialVersionUID = -8362607471453797262L;
    static final boolean I18N_DEBUG = Utility.getBooleanParameter((String)"i18n.action.debug", (boolean)false);
    protected static final String RESOURCE_PREFIX = "i18n.";
    private static final int RESOURCE_PREFIX_LENGTH = "i18n.".length();
    protected static final String ICON_PREFIX = "i18n.icon.";
    private static final int ICON_PREFIX_LENGTH = "i18n.icon.".length();
    public static final String ACCELERATOR_KEY_RESOURCE = "i18n.AcceleratorKey";
    public static final String ACTION_COMMAND_KEY_RESOURCE = "i18n.ActionCommandKey";
    public static final String LONG_DESCRIPTION_RESOURCE = "i18n.LongDescription";
    public static final String MNEMONIC_KEY_RESOURCE = "i18n.MnemonicKey";
    public static final String NAME_RESOURCE = "i18n.Name";
    public static final String SHORT_DESCRIPTION_RESOURCE = "i18n.ShortDescription";
    public static final String SMALL_ICON_RESOURCE = "i18n.icon.SmallIcon";
    public static final String POPUP_PROPERTY = "de.caff.gimmicks.swing.ResourcedAction.POPUP";
    @NotNull
    private final String baseTag;
    private Locale locale;

    protected ResourcedAction(@NotNull String string) {
        this(string, (Locale)null);
    }

    protected ResourcedAction(@NotNull String string, @Nullable Locale locale) {
        this.baseTag = string;
        this.setLocale(locale);
        try {
            this.putValue(NAME_RESOURCE, string + "-NAME[ACTION]");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            this.putValue(SHORT_DESCRIPTION_RESOURCE, string + "-TTT[ACTION]");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            this.putValue(LONG_DESCRIPTION_RESOURCE, string + "-DESCR[ACTION]");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            this.putValue(ACCELERATOR_KEY_RESOURCE, string + "-ACCEL[ACTION]");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            this.putValue(MNEMONIC_KEY_RESOURCE, string + "-MNEMO[ACTION]");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            this.putValue(SMALL_ICON_RESOURCE, string + "-ICON[ACTION]");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        I18n.addLocalizationChangeListener((Localizable)new WeakReferencedLocalizable((Localizable)this));
    }

    @NotNull
    public String getBaseTag() {
        return this.baseTag;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (!locale.equals(this.locale)) {
            this.locale = locale;
            Object[] objectArray = this.getKeys();
            if (objectArray != null) {
                for (Object object : objectArray) {
                    String string = object.toString();
                    if (!string.startsWith(RESOURCE_PREFIX)) continue;
                    this.putValue(string, this.getValue(string));
                }
            }
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void putValue(@NotNull String string, Object object) {
        if (string.startsWith(RESOURCE_PREFIX)) {
            String string2 = object.toString();
            String string3 = I18n.getString((String)string2, (Locale)this.locale);
            if (I18N_DEBUG && string2.endsWith("-TTT[ACTION]")) {
                string3 = String.format("%s [%s]", string3, string2.substring(0, string2.length() - "-TTT[ACTION]".length()));
            }
            if (string.startsWith(ICON_PREFIX)) {
                Icon icon = SwingHelper.loadIconResource(string3);
                super.putValue(string.substring(ICON_PREFIX_LENGTH), icon);
            } else if (MNEMONIC_KEY_RESOURCE.equals(string)) {
                super.putValue("MnemonicKey", string3.charAt(0));
            } else if (ACCELERATOR_KEY_RESOURCE.equals(string)) {
                super.putValue("AcceleratorKey", KeyStroke.getKeyStroke(string3));
            } else {
                super.putValue(string.substring(RESOURCE_PREFIX_LENGTH), string3);
            }
        }
        super.putValue(string, object);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean hasPopup() {
        return false;
    }
}

