/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.annotation.NotNull;
import de.caff.gimmicks.swing.FormattingHelper;
import de.caff.i18n.I18n;
import de.caff.util.measure.IllegalPhysicalLengthFormatException;
import de.caff.util.measure.PhysicalLength;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;

public class PhysicalLengthTextField
extends JFormattedTextField {
    private static final long serialVersionUID = 3019826615839351118L;

    public PhysicalLengthTextField() {
        super(new PhysicalLengthFormatter());
        FormattingHelper.installValidityHinter(this);
    }

    public PhysicalLengthTextField(@NotNull PhysicalLength physicalLength) {
        super(new PhysicalLengthFormatter());
        this.setValue(physicalLength);
    }

    public PhysicalLength getLength() {
        return (PhysicalLength)this.getValue();
    }

    public static class PhysicalLengthFormatter
    extends DefaultFormatter {
        private static final long serialVersionUID = -8591075710352207274L;

        @Override
        public Object stringToValue(String string) throws ParseException {
            if (string == null) {
                throw new ParseException("Invalid text!", 0);
            }
            try {
                return PhysicalLength.fromString((String)string, (Locale)I18n.getDefaultLocale());
            }
            catch (IllegalPhysicalLengthFormatException illegalPhysicalLengthFormatException) {
                ParseException parseException = new ParseException("Invalid length!", 0);
                parseException.initCause(illegalPhysicalLengthFormatException);
                throw parseException;
            }
        }

        @Override
        public String valueToString(Object object) throws ParseException {
            if (object == null) {
                throw new ParseException("Null value not allowed!", 0);
            }
            return object.toString();
        }

        @Override
        public PhysicalLengthFormatter clone() throws CloneNotSupportedException {
            return (PhysicalLengthFormatter)super.clone();
        }
    }
}

