/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.annotation.NotNull;
import de.caff.i18n.I18n;
import java.io.File;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileFilter;

public class MultiFileExtensionFilter
extends FileFilter {
    private static final Pattern SEPARATOR;
    private final String description;
    private final String[] extensions;
    private boolean allowDirectories = true;

    public MultiFileExtensionFilter(@NotNull String string, @NotNull String string2) {
        this(SEPARATOR.split(string), string2);
    }

    public MultiFileExtensionFilter(@NotNull String[] stringArray, String string) {
        this.description = string;
        this.extensions = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.extensions[i] = stringArray[i].startsWith(".") ? stringArray[i].toUpperCase() : "." + stringArray[i].toUpperCase();
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return this.allowDirectories;
        }
        String string = file.getName().toUpperCase();
        for (String string2 : this.extensions) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowDirectories() {
        return this.allowDirectories;
    }

    public void setAllowDirectories(boolean bl) {
        this.allowDirectories = bl;
    }

    static {
        I18n.addAppResourceBase((String)"de.caff.gimmicks.swing.GimmicksSwingResourceBundle");
        SEPARATOR = Pattern.compile("\\|");
    }
}

