/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.i18n.I18n;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import javax.swing.JTextField;

public class JDoubleTextField
extends JTextField {
    public static final String DEFAULT_FORMAT = "#####0.0#####";
    public static final String PROPERTY_VALUE = "JDoubleTextField.VALUE";
    public static final String PROPERTY_VALID = "JDoubleTextField.VALID";
    private static final Color INVALID_BACKGROUND = new Color(255, 128, 128);
    private static final long serialVersionUID = -1887684751695439541L;
    private Color defaultBG;
    private boolean valid = true;
    private double value;
    private DecimalFormat scanFormat;

    private void init(double d, String string) {
        this.value = d;
        this.scanFormat = new DecimalFormat(string, new DecimalFormatSymbols(I18n.getDefaultLocale()));
        this.setText(this.scanFormat.format(d));
        this.defaultBG = this.getBackground();
        this.addCaretListener(caretEvent -> {
            String string = this.getText();
            ParsePosition parsePosition = new ParsePosition(0);
            double d = this.value;
            boolean bl = this.valid;
            Number number = this.scanFormat.parse(string, parsePosition);
            if (number != null && parsePosition.getIndex() == string.length()) {
                this.valid = true;
                this.value = number.doubleValue();
            } else {
                this.valid = false;
            }
            if (bl != this.valid) {
                this.firePropertyChange(PROPERTY_VALID, bl, this.valid);
            }
            if (this.valid) {
                this.setBackground(this.defaultBG);
                if (this.value != d) {
                    this.firePropertyChange(PROPERTY_VALUE, d, this.value);
                }
            } else {
                this.setBackground(INVALID_BACKGROUND);
            }
        });
    }

    public JDoubleTextField() {
        this(0.0);
    }

    public JDoubleTextField(double d) {
        this.init(d, DEFAULT_FORMAT);
    }

    public JDoubleTextField(double d, String string) {
        if (string == null) {
            string = DEFAULT_FORMAT;
        }
        this.init(d, string);
    }

    public boolean isValidValue() {
        return this.valid;
    }

    public double getValue() {
        return this.isValidValue() ? this.value : Double.NaN;
    }

    public void setValue(double d) {
        this.setText(this.scanFormat.format(d));
        if (this.value != d) {
            double d2 = this.value;
            this.value = d;
            if (!this.valid) {
                this.valid = true;
                this.firePropertyChange(PROPERTY_VALID, false, true);
            }
            this.firePropertyChange(PROPERTY_VALUE, d2, d);
        }
    }
}

