/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class IconCanvasSwing
extends JComponent {
    private static final long serialVersionUID = 7269376330156773833L;
    protected ImageIcon icon;
    protected int margin;

    public IconCanvasSwing(Image image) {
        this.setImage(image);
    }

    public IconCanvasSwing(Image image, int n) {
        this.setImage(image);
        this.margin = n;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.icon != null) {
            Dimension dimension = this.getSize();
            int n = this.icon.getIconWidth();
            int n2 = this.icon.getIconHeight();
            this.icon.paintIcon(this, graphics, (dimension.width - n) / 2, (dimension.height - n2) / 2);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.icon != null) {
            int n = this.icon.getIconWidth();
            int n2 = this.icon.getIconHeight();
            return new Dimension(n + 2 * this.margin, n2 + 2 * this.margin);
        }
        return new Dimension(1, 1);
    }

    public Dimension getMinimalSize() {
        return this.getPreferredSize();
    }

    public void setImage(Image image) {
        if (image != null) {
            try {
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.icon = new ImageIcon(image);
        this.invalidate();
        this.repaint();
    }
}

