/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.annotation.NotNull;
import de.caff.util.Utility;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFormattedTextField;

public class FormattingHelper {
    public static final String PROPERTY_EDIT_VALID = "editValid";
    public static final Color INVALID_BACKGROUND = Utility.getColorParameter((String)"field.invalid.bg", (Color)new Color(255, 224, 224));

    private FormattingHelper() {
    }

    public static void installValidityHinter(final @NotNull JFormattedTextField jFormattedTextField) {
        jFormattedTextField.addPropertyChangeListener(PROPERTY_EDIT_VALID, new PropertyChangeListener(){
            private final Color bg;
            {
                this.bg = jFormattedTextField.isOpaque() ? jFormattedTextField.getBackground() : null;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (jFormattedTextField.isEditValid()) {
                    if (this.bg == null) {
                        jFormattedTextField.setOpaque(false);
                    } else {
                        jFormattedTextField.setBackground(this.bg);
                    }
                } else {
                    if (this.bg == null) {
                        jFormattedTextField.setOpaque(true);
                    }
                    jFormattedTextField.setBackground(INVALID_BACKGROUND);
                }
            }
        });
        if (!jFormattedTextField.isEditValid()) {
            jFormattedTextField.setOpaque(true);
            jFormattedTextField.setBackground(INVALID_BACKGROUND);
        }
    }
}

