/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.i18n.I18n;
import de.caff.i18n.swing.RJButton;
import de.caff.util.ImprovedStringWriter;
import de.caff.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ExtendedErrorDialog
extends JDialog
implements ClipboardOwner {
    private static final long serialVersionUID = 2767264611137546908L;
    private static final int CAPACITY = 4096;
    static final String I18N_TAG_EXCEPTION_TITLE = "XError#exception#title";
    static final String I18N_TAG_BTN_COPY = "XError#button#copy";
    static final String I18N_TAG_BTN_CLOSE = "XError#button#close";
    static final String I18N_TAG_ERROR_COPY = "XError!err#copy#msg";
    static final String I18N_TAG_TITLE_ERROR_COPY = "XError!err#copy#title";

    public ExtendedErrorDialog(@Nullable Window window, @NotNull String string, @NotNull String string2, @Nullable Throwable throwable) {
        super(window, string, Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(2);
        StringBuffer stringBuffer = new StringBuffer(4096);
        stringBuffer.append(string2).append("\n\n");
        this.getContentPane().setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        for (String object2 : string2.split("\n")) {
            box.add(new JLabel(object2, 10));
        }
        this.getContentPane().add((Component)box, "North");
        JTextArea jTextArea = new JTextArea();
        if (throwable != null) {
            String string3 = throwable.getLocalizedMessage();
            if (string3 == null || string3.isEmpty()) {
                string3 = throwable.getMessage();
            }
            ImprovedStringWriter improvedStringWriter = new ImprovedStringWriter(4096);
            PrintWriter printWriter = new PrintWriter((Writer)improvedStringWriter);
            if (string3 != null && !string3.isEmpty()) {
                printWriter.write(string3);
                printWriter.write("\n");
            }
            throwable.printStackTrace(printWriter);
            jTextArea.setText(improvedStringWriter.getBuffer().toString());
            stringBuffer.append("Exception:\n").append(improvedStringWriter.getBuffer().toString());
        }
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setMinimumSize(new Dimension(128, 192));
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), I18n.getString((String)I18N_TAG_EXCEPTION_TITLE)));
        this.getContentPane().add((Component)jScrollPane, "Center");
        Box box2 = Box.createHorizontalBox();
        RJButton rJButton = new RJButton(I18N_TAG_BTN_COPY);
        RJButton rJButton2 = new RJButton(I18N_TAG_BTN_CLOSE);
        box2.add(rJButton);
        box2.add(Box.createHorizontalGlue());
        box2.add(rJButton2);
        rJButton.addActionListener(actionEvent -> {
            try {
                Utility.copyTextToClipboard((String)stringBuffer.toString());
            }
            catch (Throwable throwable) {
                JOptionPane.showConfirmDialog(this.getContentPane(), I18n.format((String)I18N_TAG_ERROR_COPY, (Object[])new Object[]{throwable}).split("\n"), I18n.getString((String)I18N_TAG_TITLE_ERROR_COPY), -1, 0);
            }
        });
        rJButton2.addActionListener(actionEvent -> this.dispose());
        this.getContentPane().add((Component)box2, "South");
        this.pack();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    static {
        I18n.addAppResourceBase((String)"de.caff.gimmicks.swing.GimmicksSwingResourceBundle");
    }
}

