/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.gimmicks.swing.CollapsiblePane;
import de.caff.gimmicks.swing.RotatedLabelUI;
import de.caff.i18n.I18n;
import de.caff.util.debug.Debug;
import de.caff.util.swing.SwingHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.MissingResourceException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class CollapsibleTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = -6279662510054791683L;
    @NotNull
    final Side side;
    @NotNull
    final String id;
    @Nullable
    private Preferences preferences;

    public CollapsibleTabbedPane(@NotNull Side side) {
        this(side, 0);
    }

    public CollapsibleTabbedPane(@NotNull Side side, int n) {
        this("COLL_TAB_PANE", side, n);
    }

    public CollapsibleTabbedPane(@NotNull String string, @NotNull Side side) {
        this(string, side, 0);
    }

    public CollapsibleTabbedPane(@NotNull String string, @NotNull Side side, int n) {
        super(side.tabPlacement, n);
        this.id = string;
        this.side = side;
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1 || mouseEvent.getClickCount() != 2) {
                    return;
                }
                int n = CollapsibleTabbedPane.this.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n >= 0 && n == CollapsibleTabbedPane.this.getSelectedIndex()) {
                    CollapsibleTabbedPane.this.setSelectedIndex(-1);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
    }

    @NotNull
    public Side getSide() {
        return this.side;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public void addTabFromResource(@NotNull String string, @NotNull JComponent jComponent) {
        this.insertTabFromResource(string, jComponent, this.getTabCount());
    }

    public void insertTabFromResource(@NotNull String string, @NotNull JComponent jComponent, int n) {
        this.insertTab(string, CollapsibleTabbedPane.getText(string), CollapsibleTabbedPane.getIcon(string), jComponent, CollapsibleTabbedPane.getTooltip(string), n);
    }

    @Nullable
    private static String getI18nResourceOrNull(@NotNull String string) {
        try {
            return I18n.getString((String)string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    @Nullable
    private static Icon getIcon(@NotNull String string) {
        String string2 = CollapsibleTabbedPane.getI18nResourceOrNull(string + "-ICON[ACTION]");
        if (string2 != null) {
            return SwingHelper.loadIconResource(string2);
        }
        return null;
    }

    @Nullable
    private static String getText(@NotNull String string) {
        return CollapsibleTabbedPane.getI18nResourceOrNull(string + "-NAME[ACTION]");
    }

    @Nullable
    private static String getTooltip(@NotNull String string) {
        return CollapsibleTabbedPane.getI18nResourceOrNull(string + "-TTT[ACTION]");
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        this.insertTab(string == null ? Integer.toString(n) : string, string, icon, component, string2, n);
    }

    public void insertTab(@NotNull String string, @Nullable String string2, @Nullable Icon icon, @NotNull Component component, @Nullable String string3, int n) {
        if (string2 == null) {
            string2 = "";
        }
        CollapsiblePane collapsiblePane = new CollapsiblePane(this, string, string2, (JComponent)component);
        super.insertTab(string2, icon, collapsiblePane, string3, n);
        if (this.preferences != null) {
            SwingUtilities.invokeLater(() -> collapsiblePane.loadPreferences(this.preferences));
        }
        switch (this.side) {
            case North: {
                break;
            }
            case East: {
                JLabel jLabel = new JLabel(string2, icon, 10){
                    private static final long serialVersionUID = -6373582197823167286L;

                    @Override
                    public void updateUI() {
                        this.setUI(new RotatedLabelUI(false));
                    }
                };
                jLabel.setUI(new RotatedLabelUI(false));
                this.setTabComponentAt(n, jLabel);
                break;
            }
            case South: {
                break;
            }
            case West: {
                JLabel jLabel = new JLabel(string2, icon, 10){
                    private static final long serialVersionUID = -3197594686535605227L;

                    @Override
                    public void updateUI() {
                        this.setUI(new RotatedLabelUI(true));
                    }
                };
                jLabel.setUI(new RotatedLabelUI(true));
                this.setTabComponentAt(n, jLabel);
            }
        }
    }

    public void loadPreferences(@NotNull Preferences preferences) {
        this.preferences = preferences;
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            try {
                CollapsiblePane collapsiblePane = (CollapsiblePane)this.getComponentAt(i);
                collapsiblePane.loadPreferences(preferences);
                continue;
            }
            catch (ClassCastException classCastException) {
                Debug.error((Throwable)classCastException);
            }
        }
    }

    public void storePreferences(@NotNull Preferences preferences) {
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            try {
                CollapsiblePane collapsiblePane = (CollapsiblePane)this.getComponentAt(i);
                collapsiblePane.storePreferences(preferences);
                continue;
            }
            catch (ClassCastException classCastException) {
                Debug.error((Throwable)classCastException);
            }
        }
    }

    @Override
    public int indexOfComponent(Component component) {
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            try {
                CollapsiblePane collapsiblePane = (CollapsiblePane)this.getComponentAt(i);
                if (collapsiblePane == component) {
                    return i;
                }
                if (collapsiblePane.getInternalComponent() != component) continue;
                return i;
            }
            catch (ClassCastException classCastException) {
                Debug.error((Throwable)classCastException);
            }
        }
        return -1;
    }

    @Override
    public void setSelectedIndex(int n) {
        super.setSelectedIndex(n);
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            ((CollapsiblePane)this.getComponentAt(i)).setExpanded(i == n);
        }
    }

    static {
        I18n.addAppResourceBase((String)"de.caff.gimmicks.swing.GimmicksSwingResourceBundle");
    }

    public static enum Side implements DirectionHelper,
    DividerHandler
    {
        North(1, "North", 9, ExpandableDirection.Vertically, "CollapsiblePane.Hide.North", new InsetsDividerHandler(){

            @Override
            public void setDivider(@NotNull JComponent jComponent, int n, @Nullable Color color) {
                this.setDivider(jComponent, 0, 0, n, 0, color);
            }

            @Override
            public boolean isOverDivider(@NotNull JComponent jComponent, @NotNull Point point, int n) {
                return jComponent.getHeight() - point.y < n;
            }

            @Override
            @NotNull
            public Dimension getSize(@NotNull JComponent jComponent, @NotNull Point point, int n) {
                return new Dimension(jComponent.getWidth(), point.y + n / 2);
            }
        }),
        East(4, "East", 10, ExpandableDirection.Horizontally, "CollapsiblePane.Hide.East", new InsetsDividerHandler(){

            @Override
            public void setDivider(@NotNull JComponent jComponent, int n, @Nullable Color color) {
                this.setDivider(jComponent, 0, n, 0, 0, color);
            }

            @Override
            public boolean isOverDivider(@NotNull JComponent jComponent, @NotNull Point point, int n) {
                return point.x < n;
            }

            @Override
            @NotNull
            public Dimension getSize(@NotNull JComponent jComponent, @NotNull Point point, int n) {
                return new Dimension(jComponent.getWidth() - point.x - n / 2, jComponent.getHeight());
            }
        }),
        South(3, "South", 8, ExpandableDirection.Vertically, "CollapsiblePane.Hide.South", new InsetsDividerHandler(){

            @Override
            public void setDivider(@NotNull JComponent jComponent, int n, @Nullable Color color) {
                this.setDivider(jComponent, n, 0, 0, 0, color);
            }

            @Override
            public boolean isOverDivider(@NotNull JComponent jComponent, @NotNull Point point, int n) {
                return point.y < n;
            }

            @Override
            @NotNull
            public Dimension getSize(@NotNull JComponent jComponent, @NotNull Point point, int n) {
                return new Dimension(jComponent.getWidth(), jComponent.getHeight() - point.y - n / 2);
            }
        }),
        West(2, "West", 11, ExpandableDirection.Horizontally, "CollapsiblePane.Hide.West", new InsetsDividerHandler(){

            @Override
            public void setDivider(@NotNull JComponent jComponent, int n, @Nullable Color color) {
                this.setDivider(jComponent, 0, 0, 0, n, color);
            }

            @Override
            public boolean isOverDivider(@NotNull JComponent jComponent, @NotNull Point point, int n) {
                return jComponent.getWidth() - point.x < n;
            }

            @Override
            @NotNull
            public Dimension getSize(@NotNull JComponent jComponent, @NotNull Point point, int n) {
                return new Dimension(point.x + n / 2, jComponent.getHeight());
            }
        });

        final int tabPlacement;
        @NotNull
        final String naturalBorder;
        @NotNull
        final String i18nHideActionTag;
        @NotNull
        private final ExpandableDirection expandableDirection;
        @NotNull
        private final DividerHandler dividerHandler;
        @NotNull
        private final Cursor resizeCursor;

        private Side(int n2, @NotNull String string2, @NotNull int n3, @NotNull ExpandableDirection expandableDirection, String string3, DividerHandler dividerHandler) {
            this.tabPlacement = n2;
            this.naturalBorder = string2;
            this.expandableDirection = expandableDirection;
            this.i18nHideActionTag = string3;
            this.dividerHandler = dividerHandler;
            this.resizeCursor = Cursor.getPredefinedCursor(n3);
        }

        public int getTabPlacement() {
            return this.tabPlacement;
        }

        @NotNull
        public String getNaturalBorder() {
            return this.naturalBorder;
        }

        @NotNull
        public String getI18nHideActionTag() {
            return this.i18nHideActionTag;
        }

        @NotNull
        public ExpandableDirection getExpandableDirection() {
            return this.expandableDirection;
        }

        @NotNull
        public Cursor getResizeCursor() {
            return this.resizeCursor;
        }

        @Override
        @NotNull
        public Dimension getDimension(@NotNull Dimension dimension, int n) {
            return this.expandableDirection.getDimension(dimension, n);
        }

        @Override
        public int getCoordinateOfInterest(int n, int n2) {
            return this.expandableDirection.getCoordinateOfInterest(n, n2);
        }

        @Override
        public void setDivider(@NotNull JComponent jComponent, int n, @Nullable Color color) {
            this.dividerHandler.setDivider(jComponent, n, color);
        }

        @Override
        public boolean isOverDivider(@NotNull JComponent jComponent, @NotNull Point point, int n) {
            return this.dividerHandler.isOverDivider(jComponent, point, n);
        }

        @Override
        @NotNull
        public Dimension getSize(@NotNull JComponent jComponent, @NotNull Point point, int n) {
            return this.dividerHandler.getSize(jComponent, point, n);
        }
    }

    private static abstract class InsetsDividerHandler
    implements DividerHandler {
        private InsetsDividerHandler() {
        }

        protected void setDivider(@NotNull JComponent jComponent, int n, int n2, int n3, int n4, @Nullable Color color) {
            if (color != null) {
                jComponent.setBorder(BorderFactory.createMatteBorder(n, n2, n3, n4, color));
            } else {
                jComponent.setBorder(BorderFactory.createEmptyBorder(n, n2, n3, n4));
            }
        }
    }

    private static interface DividerHandler {
        public void setDivider(@NotNull JComponent var1, int var2, @Nullable Color var3);

        public boolean isOverDivider(@NotNull JComponent var1, @NotNull Point var2, int var3);

        @NotNull
        public Dimension getSize(@NotNull JComponent var1, @NotNull Point var2, int var3);
    }

    public static enum ExpandableDirection implements DirectionHelper
    {
        Horizontally{

            @Override
            @NotNull
            public Dimension getDimension(@NotNull Dimension dimension, int n) {
                return new Dimension(n, dimension.height);
            }

            @Override
            public int getCoordinateOfInterest(int n, int n2) {
                return n;
            }
        }
        ,
        Vertically{

            @Override
            @NotNull
            public Dimension getDimension(@NotNull Dimension dimension, int n) {
                return new Dimension(dimension.width, n);
            }

            @Override
            public int getCoordinateOfInterest(int n, int n2) {
                return n2;
            }
        };

    }

    private static interface DirectionHelper {
        @NotNull
        public Dimension getDimension(@NotNull Dimension var1, int var2);

        public int getCoordinateOfInterest(int var1, int var2);
    }
}

