/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.gimmicks.swing.CollapsibleTabbedPane;
import de.caff.gimmicks.swing.ResourcedAction;
import de.caff.util.debug.Debug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class CollapsiblePane
extends JPanel
implements PreferenceChangeListener {
    private static final long serialVersionUID = 8173423979719285623L;
    private static final int DIVIDER_SIZE = 8;
    static final String I18N_TAG_ACTION_HIDE_NORTH = "CollapsiblePane.Hide.North";
    static final String I18N_TAG_ACTION_HIDE_EAST = "CollapsiblePane.Hide.East";
    static final String I18N_TAG_ACTION_HIDE_SOUTH = "CollapsiblePane.Hide.South";
    static final String I18N_TAG_ACTION_HIDE_WEST = "CollapsiblePane.Hide.West";
    @NotNull
    private final CollapsibleTabbedPane tabbed;
    @NotNull
    private final JLabel titleLabel;
    @NotNull
    private final Box titleBar;
    @NotNull
    private final JComponent internalComponent;
    private int expandedSize = -1;
    private boolean expanded = true;
    @Nullable
    private Preferences preferences;
    @NotNull
    private final String preferenceKey;
    private boolean initialising = true;

    CollapsiblePane(final @NotNull CollapsibleTabbedPane collapsibleTabbedPane, @NotNull String string, @NotNull String string2, @NotNull JComponent jComponent) {
        super(new BorderLayout());
        this.preferenceKey = string;
        this.tabbed = collapsibleTabbedPane;
        ResourcedAction resourcedAction = new ResourcedAction(collapsibleTabbedPane.side.i18nHideActionTag){
            private static final long serialVersionUID = 3014693439018404326L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                collapsibleTabbedPane.setSelectedIndex(-1);
                collapsibleTabbedPane.invalidate();
                collapsibleTabbedPane.repaint();
            }
        };
        this.titleBar = Box.createHorizontalBox();
        JButton jButton = new JButton(resourcedAction);
        jButton.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.titleBar.add(jButton);
        this.titleLabel = new JLabel(string2);
        this.titleBar.add(this.titleLabel);
        this.titleBar.add(Box.createHorizontalGlue());
        JButton jButton2 = new JButton(resourcedAction);
        jButton2.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.titleBar.add(jButton2);
        this.titleBar.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, Color.black));
        this.add((Component)this.titleBar, "North");
        this.add((Component)jComponent, "Center");
        this.internalComponent = jComponent;
        this.setMinimumSize(new Dimension(0, 0));
        this.setExpanded(false);
        this.setDividerActive(false, false);
        MouseAdapter mouseAdapter = new MouseAdapter(){
            private Boolean hasDragged;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && collapsibleTabbedPane.side.isOverDivider(CollapsiblePane.this, mouseEvent.getPoint(), 8)) {
                    this.hasDragged = false;
                    CollapsiblePane.this.setDividerActive(true, true);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (this.hasDragged != null && this.hasDragged.booleanValue() && mouseEvent.getButton() == 1) {
                    this.updateSize(mouseEvent.getPoint(), true);
                }
                this.hasDragged = null;
                CollapsiblePane.this.setDividerActive(mouseEvent.getX() < 8, false);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.mouseMoved(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                CollapsiblePane.this.setDividerActive(collapsibleTabbedPane.side.isOverDivider(CollapsiblePane.this, mouseEvent.getPoint(), 8), this.hasDragged != null);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                CollapsiblePane.this.setDividerActive(false, this.hasDragged != null);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (this.hasDragged != null) {
                    this.hasDragged = true;
                    this.updateSize(mouseEvent.getPoint(), false);
                }
            }

            void updateSize(@NotNull Point point, boolean bl) {
                Dimension dimension = collapsibleTabbedPane.side.getSize(CollapsiblePane.this, point, 8);
                dimension = CollapsiblePane.this.getRestrictedDimension(dimension, 0.9);
                CollapsiblePane.this.setPreferredSize(dimension);
                CollapsiblePane.this.setSize(dimension);
                collapsibleTabbedPane.revalidate();
                collapsibleTabbedPane.repaint();
                CollapsiblePane.this.expandedSize = collapsibleTabbedPane.side.getCoordinateOfInterest(dimension.width, dimension.height);
                if (bl && CollapsiblePane.this.preferences != null) {
                    CollapsiblePane.this.storePreferences(CollapsiblePane.this.preferences);
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    @NotNull
    public JComponent getInternalComponent() {
        return this.internalComponent;
    }

    private void setDividerActive(boolean bl, boolean bl2) {
        if (bl2) {
            this.setCursor(this.tabbed.side.getResizeCursor());
            this.tabbed.side.setDivider(this, 8, UIManager.getColor("MenuItem.selectionBackground"));
        } else if (bl) {
            this.setCursor(this.tabbed.side.getResizeCursor());
            this.tabbed.side.setDivider(this, 8, UIManager.getColor("TabbedPane.highlight"));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
            this.tabbed.side.setDivider(this, 8, null);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.expanded) {
            Dimension dimension = super.getPreferredSize();
            if (this.initialising) {
                dimension = this.getRestrictedDimension(dimension, 0.5);
                this.initialising = false;
            }
            return dimension;
        }
        return this.tabbed.side.getDimension(super.getPreferredSize(), 0);
    }

    @NotNull
    private Dimension getRestrictedDimension(@NotNull Dimension dimension, double d) {
        Container container = this.tabbed.getParent();
        if (container != null) {
            Dimension dimension2 = container.getSize();
            int n = this.tabbed.side.getCoordinateOfInterest(dimension2.width, dimension2.height);
            int n2 = this.tabbed.side.getCoordinateOfInterest(dimension.width, dimension.height);
            if (n2 < 8 || n2 > (int)((double)n * d) - 8) {
                dimension = !this.initialising && n2 < 16 ? this.tabbed.side.getDimension(dimension, 16) : this.tabbed.side.getDimension(dimension, (int)((double)n * d) - 8);
                this.setPreferredSize(dimension);
            }
        }
        return dimension;
    }

    @Override
    public Dimension getSize() {
        if (this.expanded) {
            return super.getSize();
        }
        return this.tabbed.side.getDimension(super.getSize(), 0);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.expanded) {
            return super.getMinimumSize();
        }
        return this.tabbed.side.getDimension(super.getMinimumSize(), 0);
    }

    void setExpanded(boolean bl) {
        if (this.expanded == bl) {
            return;
        }
        this.expanded = bl;
        boolean bl2 = this.isVisible();
        if (bl2) {
            this.expandedSize = this.tabbed.side.getCoordinateOfInterest(this.getWidth(), this.getHeight());
        } else if (bl) {
            this.setSize(this.tabbed.side.getDimension(this.getSize(), this.expandedSize));
        }
        this.setVisible(bl);
        if (!bl) {
            this.setSize(this.tabbed.side.getDimension(this.getSize(), 0));
        }
        this.tabbed.revalidate();
    }

    @NotNull
    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    @NotNull
    private String getExpandedSizeKey() {
        return String.format("%s.%s.expandedSize", this.tabbed.id, this.preferenceKey);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.preferences != null) {
            this.preferences.removePreferenceChangeListener(this);
        }
    }

    public void loadPreferences(@NotNull Preferences preferences) {
        int n = preferences.getInt(this.getExpandedSizeKey(), -1);
        if (n > 0) {
            this.expandedSize = n;
            Dimension dimension = this.tabbed.side.getDimension(this.getSize(), this.expandedSize);
            this.setPreferredSize(dimension);
            this.setSize(dimension);
            this.tabbed.revalidate();
            this.tabbed.repaint();
        }
        if (this.preferences != null) {
            this.preferences.removePreferenceChangeListener(this);
        }
        preferences.addPreferenceChangeListener(this);
        this.preferences = preferences;
    }

    public void storePreferences(@NotNull Preferences preferences) {
        if (this.expandedSize > 0) {
            preferences.putInt(this.getExpandedSizeKey(), this.expandedSize);
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (this.getExpandedSizeKey().equals(preferenceChangeEvent.getKey())) {
            try {
                int n = Integer.parseInt(preferenceChangeEvent.getNewValue());
                if (n != this.expandedSize) {
                    this.expandedSize = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Debug.error((Throwable)numberFormatException);
            }
        }
    }
}

