/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.i18n.I18n;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;

public class CloseableTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = -700158248486815620L;
    private static final MouseListener ROLLOVER_LISTENER;
    private static final Stroke CROSS_STROKE;
    private static final Color ACTIVE_FG_COLOR;
    private static final Color ACTIVE_BG_COLOR;
    private static final Color DARKER_BG_COLOR;
    private static final Color LIGHTER_BG_COLOR;

    public CloseableTabbedPane() {
    }

    public CloseableTabbedPane(int n) {
        super(n);
    }

    public CloseableTabbedPane(int n, int n2) {
        super(n, n2);
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        super.insertTab(string, icon, component, string2, n);
        this.setTabComponentAt(n, new JLabel(){
            private static final long serialVersionUID = 3727051960111348866L;

            @Override
            public String getText() {
                int n = CloseableTabbedPane.this.indexOfTabComponent(this);
                return n >= 0 ? CloseableTabbedPane.this.getTitleAt(n) : null;
            }

            @Override
            public Icon getIcon() {
                int n = CloseableTabbedPane.this.indexOfTabComponent(this);
                return n >= 0 ? CloseableTabbedPane.this.getIconAt(n) : null;
            }
        });
    }

    @Override
    public void setTabComponentAt(int n, Component component) {
        super.setTabComponentAt(n, component == null ? null : new CloseableTab(component));
    }

    @Override
    public int indexOfTabComponent(Component component) {
        if (component == null || component instanceof CloseableTab) {
            return super.indexOfTabComponent(component);
        }
        Container container = component.getParent();
        if (container != null && container instanceof CloseableTab) {
            return super.indexOfTabComponent(container);
        }
        return super.indexOfTabComponent(component);
    }

    static {
        I18n.addAppResourceBase((String)"de.caff.gimmicks.swing.GimmicksSwingResourceBundle");
        ROLLOVER_LISTENER = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                Component component = mouseEvent.getComponent();
                if (component instanceof CloseButton) {
                    ((CloseButton)component).setRollOver(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                Component component = mouseEvent.getComponent();
                if (component instanceof CloseButton) {
                    ((CloseButton)component).setRollOver(false);
                }
            }
        };
        CROSS_STROKE = new BasicStroke(2.0f, 0, 0);
        ACTIVE_FG_COLOR = Color.white;
        ACTIVE_BG_COLOR = new Color(192, 0, 0);
        DARKER_BG_COLOR = ACTIVE_BG_COLOR.darker();
        LIGHTER_BG_COLOR = ACTIVE_BG_COLOR.brighter();
    }

    private static class CloseButton
    extends JButton {
        private static final long serialVersionUID = -1353081873873986435L;
        private static final int BORDER = 2;
        private static final int CROSS_INSET = 4;
        private static final int SIZE = 15;
        private boolean rollOver;

        public CloseButton() {
            this.setUI(new BasicButtonUI());
            this.setPreferredSize(new Dimension(15, 15));
            this.setToolTipText(I18n.getString((String)"btCloseTab-TTT[ACTION]"));
            this.setFocusable(false);
            this.setBorder(null);
            this.setContentAreaFilled(false);
            this.addMouseListener(ROLLOVER_LISTENER);
        }

        public void setRollOver(boolean bl) {
            if (bl != this.rollOver) {
                this.rollOver = bl;
                this.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                boolean bl = this.getModel().isPressed();
                int n = this.getWidth();
                int n2 = this.getHeight();
                if (this.rollOver) {
                    graphics2D.setColor(ACTIVE_BG_COLOR);
                    graphics2D.fillRect(2, 2, n - 2 - 2, n2 - 2 - 2);
                    graphics2D.setColor(bl ? DARKER_BG_COLOR : LIGHTER_BG_COLOR);
                    graphics2D.drawLine(2, 2, n - 2 - 1, 2);
                    graphics2D.drawLine(2, 3, 2, n2 - 2 - 1);
                    graphics2D.setColor(bl ? LIGHTER_BG_COLOR : DARKER_BG_COLOR);
                    graphics2D.drawLine(3, n2 - 2 - 1, n - 2 - 1, n2 - 2 - 1);
                    graphics2D.drawLine(n - 2 - 1, 3, n - 2 - 1, n2 - 2 - 2);
                    graphics2D.setColor(ACTIVE_FG_COLOR);
                } else {
                    graphics2D.setColor(this.getForeground());
                }
                graphics2D.setStroke(CROSS_STROKE);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int n3 = Math.min(n, n2) - 8 - 1;
                if (n3 > 0) {
                    graphics2D.drawLine((n - n3) / 2, (n2 - n3) / 2, (n + n3) / 2, (n2 + n3) / 2);
                    graphics2D.drawLine((n + n3) / 2, (n2 - n3) / 2, (n - n3) / 2, (n2 + n3) / 2);
                }
            }
            finally {
                graphics2D.dispose();
            }
        }

        @Override
        public void updateUI() {
        }
    }

    private class CloseableTab
    extends JPanel {
        private static final long serialVersionUID = -5447529075262040118L;

        public CloseableTab(Component component) {
            this.setLayout(new BorderLayout(4, 0));
            this.add(component, "Center");
            CloseButton closeButton = new CloseButton();
            closeButton.addActionListener(actionEvent -> {
                int n = CloseableTabbedPane.this.indexOfTabComponent(this);
                if (n >= 0) {
                    CloseableTabbedPane.this.removeTabAt(n);
                }
            });
            this.add((Component)closeButton, "East");
            this.setOpaque(false);
        }

        public Component getComponent() {
            return this.getComponent(0);
        }
    }
}

