/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.annotation.NotNull;
import de.caff.gimmicks.swing.State;
import de.caff.gimmicks.swing.StateButton;
import de.caff.gimmicks.swing.StateManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JToolBar;

public abstract class AbstractState
implements State {
    protected final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected final Map<String, Object> properties = new HashMap<String, Object>();
    protected StateManager manager;

    public AbstractState() {
        this.setPropertyInternal("ACTIVATION", Boolean.FALSE);
        this.setPropertyInternal("ENABLE", Boolean.TRUE);
    }

    @Override
    public void setManager(@NotNull StateManager stateManager) {
        this.manager = stateManager;
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(@NotNull String string, @NotNull PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(@NotNull String string, @NotNull PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public boolean activate() {
        if (!this.isActivated()) {
            if (this.manager == null || this.manager.mayActivate(this)) {
                this.setPropertyInternal("ACTIVATION", Boolean.TRUE);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.activate();
    }

    @Override
    public boolean isActivated() {
        return (Boolean)this.properties.get("ACTIVATION");
    }

    @Override
    public void deactivate() {
        if (this.isActivated()) {
            this.setPropertyInternal("ACTIVATION", Boolean.FALSE);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.isEnabled() != bl && (this.manager == null || this.manager.mayEnable(this, bl))) {
            this.setPropertyInternal("ENABLE", bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.properties.get("ENABLE");
    }

    @Override
    public Object getValue(@NotNull String string) {
        return this.properties.get(string);
    }

    @Override
    public void putValue(@NotNull String string, Object object) {
        Object object2 = this.getValue(string);
        if (object2 != object || object2 != null && !object2.equals(object)) {
            this.properties.put(string, object);
            this.propertyChangeSupport.firePropertyChange(string, object2, object);
        }
    }

    protected void setProperty(@NotNull String string, Object object) {
        Object object2 = this.getValue(string);
        if ("ACTIVATION".equals(string) || "ENABLE".equals(string)) {
            throw new RuntimeException("Don't set property " + string + " via setProperty(). Use dedicated method instead.");
        }
        if (!(object2 == object || object != null && object2 != null && object.equals(object2))) {
            this.properties.put(string, object);
            this.propertyChangeSupport.firePropertyChange(string, object2, object);
        }
    }

    private void setPropertyInternal(String string, Object object) {
        Object object2 = this.getValue(string);
        this.properties.put(string, object);
        this.propertyChangeSupport.firePropertyChange(string, object2, object);
    }

    @Override
    public void showPopup(@NotNull Component component, int n, int n2) {
    }

    @Override
    @NotNull
    public JComponent[] addToToolBar(@NotNull JToolBar jToolBar) {
        StateButton stateButton = new StateButton(this);
        jToolBar.add(stateButton);
        return new JComponent[]{stateButton};
    }

    @Override
    @NotNull
    public JComponent[] addToToolBar(@NotNull JToolBar jToolBar, int n) {
        StateButton stateButton = new StateButton(this);
        jToolBar.add(stateButton, null, n);
        return new JComponent[]{stateButton};
    }

    @Override
    public boolean isToggleEnabled() {
        return false;
    }

    @Override
    public void refresh() {
    }
}

