/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class TextureFactory {
    private static TextureFactory fac = null;
    private Map<ColoredTexture, Paint> textures = new HashMap<ColoredTexture, Paint>(1);
    private static final int SIZE = 10;
    private float scale = 1.0f;

    private TextureFactory(float f) {
    }

    public static TextureFactory getInstance() {
        if (fac == null) {
            fac = new TextureFactory(1.0f);
        }
        return fac;
    }

    public static TextureFactory getInstance(float f) {
        if (fac == null) {
            fac = new TextureFactory(f);
        }
        return fac;
    }

    public void reset() {
        this.textures.clear();
    }

    public Paint getTexture(int n, Color color) {
        ColoredTexture coloredTexture = new ColoredTexture(n, color, null);
        if (this.textures.containsKey(coloredTexture)) {
            return this.textures.get(coloredTexture);
        }
        Paint paint = this.createTexture(n, color, null);
        if (paint != null) {
            this.textures.put(coloredTexture, paint);
        }
        return paint;
    }

    public Paint getTexture(int n, Color color, Color color2) {
        ColoredTexture coloredTexture = new ColoredTexture(n, color, color2);
        if (this.textures.containsKey(coloredTexture)) {
            return this.textures.get(coloredTexture);
        }
        Paint paint = this.createTexture(n, color, color2);
        if (paint != null) {
            this.textures.put(coloredTexture, paint);
        }
        return paint;
    }

    private Paint createTexture(int n, Color color, Color color2) {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, 10.0f, 10.0f);
        TexturePaint texturePaint = null;
        boolean bl = false;
        if (color2 != null) {
            graphics2D.setColor(color2);
            graphics2D.fillRect(0, 0, 10, 10);
        }
        if (color == null) {
            graphics2D.setColor(Color.black);
        } else {
            graphics2D.setColor(color);
        }
        if (n == 1) {
            for (int i = 0; i < 5; ++i) {
                graphics2D.drawLine(i * 10, 0, i * 10, 10);
            }
            bl = true;
        } else if (n == 0) {
            for (int i = 0; i < 5; ++i) {
                graphics2D.drawLine(0, i * 10, 10, i * 10);
            }
            bl = true;
        } else if (n == 3) {
            for (int i = 0; i < 5; ++i) {
                graphics2D.drawLine(0, i * 10, i * 10, 0);
            }
            bl = true;
        } else if (n == 2) {
            for (int i = 0; i < 5; ++i) {
                graphics2D.drawLine(0, i * 10, 10 - i * 10, 10);
            }
            bl = true;
        } else if (n == 5) {
            for (int i = 0; i < 5; ++i) {
                graphics2D.drawLine(0, i * 10, i * 10, 0);
                graphics2D.drawLine(0, i * 10, 10 - i * 10, 10);
            }
            bl = true;
        } else if (n == 4) {
            for (int i = 0; i < 5; ++i) {
                graphics2D.drawLine(i * 10, 0, i * 10, 10);
                graphics2D.drawLine(0, i * 10, 10, i * 10);
            }
            bl = true;
        }
        bufferedImage.flush();
        if (bl) {
            texturePaint = new TexturePaint(bufferedImage, float_);
        }
        return texturePaint;
    }

    private class ColoredTexture {
        final int textureId;
        final Color foreground;
        final Color background;

        ColoredTexture(int n, Color color, Color color2) {
            this.textureId = n;
            this.foreground = color;
            this.background = color2;
        }
    }
}

