/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.io.DataInputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.transcoder.wmf.tosvg.AbstractWMFReader;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord$ByteRecord;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord$StringRecord;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WMFRecordStore
extends AbstractWMFReader {
    private URL a;
    protected int numRecords;
    protected float vpX;
    protected float vpY;
    protected List records;
    private boolean a = true;

    public WMFRecordStore() {
        this.reset();
    }

    @Override
    public void reset() {
        this.numRecords = 0;
        this.vpX = 0.0f;
        this.vpY = 0.0f;
        this.vpW = 1000;
        this.vpH = 1000;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.scaleXY = 1.0f;
        this.inch = 84;
        this.records = new LinkedList();
    }

    @Override
    protected boolean readRecords(DataInputStream dataInputStream) {
        int n2 = 1;
        this.numRecords = 0;
        while (n2 > 0) {
            int n3 = this.readInt(dataInputStream);
            n3 -= 3;
            short s2 = this.readShort(dataInputStream);
            n2 = s2;
            if (s2 <= 0) break;
            Object object = new MetaRecord();
            switch (n2) {
                case 259: {
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    short s3 = this.readShort(dataInputStream);
                    int n4 = s3;
                    if (s3 == 8) {
                        this.isotropic = false;
                    }
                    ((MetaRecord)object).addElement(n4);
                    this.records.add(object);
                    break;
                }
                case 1583: {
                    int n4;
                    for (n4 = 0; n4 < n3; ++n4) {
                        this.readShort(dataInputStream);
                    }
                    --this.numRecords;
                    break;
                }
                case 2610: {
                    int n5;
                    int n6;
                    int n4 = this.readShort(dataInputStream) * this.ySign;
                    int n7 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n8 = this.readShort(dataInputStream);
                    int n9 = this.readShort(dataInputStream);
                    int n10 = 4;
                    int n11 = 0;
                    int n12 = 0;
                    int n13 = 0;
                    int n14 = 0;
                    int n15 = 0;
                    if ((n9 & 4) != 0) {
                        n12 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                        n13 = this.readShort(dataInputStream) * this.ySign;
                        n14 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                        n15 = this.readShort(dataInputStream) * this.ySign;
                        n10 += 4;
                        n11 = 1;
                    }
                    byte[] byArray = new byte[n8];
                    int n16 = -1;
                    for (n6 = 0; n6 < n8; ++n6) {
                        n5 = dataInputStream.readByte();
                        if (n5 == 0 && n16 < 0) {
                            n16 = n6;
                        }
                        byArray[n6] = n5;
                    }
                    n10 += (n8 + 1) / 2;
                    if (n8 % 2 != 0) {
                        dataInputStream.readByte();
                    }
                    if (n10 < n3) {
                        for (n5 = n10; n5 < n3; ++n5) {
                            this.readShort(dataInputStream);
                        }
                    }
                    if (n16 >= 0) {
                        byte[] byArray2 = new byte[n16];
                        if (n16 > 0) {
                            System.arraycopy(byArray, 0, byArray2, 0, n16);
                            byArray = byArray2;
                        }
                    }
                    object = new MetaRecord$ByteRecord(byArray);
                    new MetaRecord$ByteRecord(byArray).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    ((MetaRecord)object).addElement(n7);
                    ((MetaRecord)object).addElement(n4);
                    ((MetaRecord)object).addElement(n9);
                    if (n11 != 0) {
                        ((MetaRecord)object).addElement(n12);
                        ((MetaRecord)object).addElement(n13);
                        ((MetaRecord)object).addElement(n14);
                        ((MetaRecord)object).addElement(n15);
                    }
                    this.records.add(object);
                    break;
                }
                case 1313: {
                    int n11;
                    int n10;
                    int n4 = this.readShort(dataInputStream);
                    byte[] byArray = new byte[n4];
                    int n9 = -1;
                    for (n10 = 0; n10 < n4; ++n10) {
                        n11 = dataInputStream.readByte();
                        if (n11 == 0 && n9 < 0) {
                            n9 = n10;
                        }
                        byArray[n10] = n11;
                    }
                    if (n4 % 2 != 0) {
                        dataInputStream.readByte();
                    }
                    int n17 = 1 + (n4 + 1) / 2;
                    n10 = this.readShort(dataInputStream) * this.ySign;
                    n11 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    if ((n17 += 2) < n3) {
                        for (int i2 = n17; i2 < n3; ++i2) {
                            this.readShort(dataInputStream);
                        }
                    }
                    if (n9 >= 0) {
                        byte[] byArray3 = new byte[n9];
                        if (n9 > 0) {
                            System.arraycopy(byArray, 0, byArray3, 0, n9);
                            byArray = byArray3;
                        }
                    }
                    object = new MetaRecord$ByteRecord(byArray);
                    new MetaRecord$ByteRecord(byArray).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    ((MetaRecord)object).addElement(n11);
                    ((MetaRecord)object).addElement(n10);
                    this.records.add(object);
                    break;
                }
                case 763: {
                    int n4 = this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    short s4 = this.readShort(dataInputStream);
                    int n9 = this.readShort(dataInputStream);
                    int n10 = this.readShort(dataInputStream);
                    int n11 = dataInputStream.readByte();
                    byte by2 = dataInputStream.readByte();
                    int n13 = dataInputStream.readByte();
                    int n14 = dataInputStream.readByte() & 0xFF;
                    dataInputStream.readByte();
                    dataInputStream.readByte();
                    dataInputStream.readByte();
                    dataInputStream.readByte();
                    int n18 = 2 * (n3 - 9);
                    byte[] byArray = new byte[n18];
                    int n19 = n18;
                    dataInputStream.readFully(byArray);
                    for (int i3 = 0; i3 < n18; ++i3) {
                        if (byArray[i3] != 0) continue;
                        n19 = i3;
                        break;
                    }
                    String string = new String(byArray, 0, n19, "ISO-8859-1");
                    object = new MetaRecord$StringRecord(string);
                    new MetaRecord$StringRecord(string).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    ((MetaRecord)object).addElement(n4);
                    ((MetaRecord)object).addElement(n11);
                    ((MetaRecord)object).addElement(n10);
                    ((MetaRecord)object).addElement(n14);
                    ((MetaRecord)object).addElement(by2);
                    ((MetaRecord)object).addElement(n13);
                    ((MetaRecord)object).addElement(n9);
                    ((MetaRecord)object).addElement(s4);
                    this.records.add(object);
                    break;
                }
                case 523: 
                case 524: 
                case 525: 
                case 526: {
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    int n4 = this.readShort(dataInputStream);
                    short s5 = this.readShort(dataInputStream);
                    if (s5 < 0) {
                        s5 = -s5;
                        this.xSign = -1;
                    }
                    if (n4 < 0) {
                        n4 = -n4;
                        this.ySign = -1;
                    }
                    if (this.a && n2 == 524) {
                        this.vpW = s5;
                        this.vpH = n4;
                        this.a = false;
                    }
                    if (!this.isAldus) {
                        this.width = this.vpW;
                        this.height = this.vpH;
                    }
                    ((MetaRecord)object).addElement((int)((float)s5 * this.scaleXY));
                    ((MetaRecord)object).addElement(n4);
                    this.records.add(object);
                    break;
                }
                case 527: 
                case 529: {
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    int n4 = this.readShort(dataInputStream) * this.ySign;
                    int n20 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    ((MetaRecord)object).addElement(n20);
                    ((MetaRecord)object).addElement(n4);
                    this.records.add(object);
                    break;
                }
                case 1040: 
                case 1042: {
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    int n4 = this.readShort(dataInputStream);
                    short s6 = this.readShort(dataInputStream);
                    short s7 = this.readShort(dataInputStream);
                    int n9 = this.readShort(dataInputStream);
                    ((MetaRecord)object).addElement(s7);
                    ((MetaRecord)object).addElement(n4);
                    ((MetaRecord)object).addElement(n9);
                    ((MetaRecord)object).addElement(s6);
                    this.records.add(object);
                    this.scaleX = this.scaleX * (float)s7 / (float)n9;
                    this.scaleY = this.scaleY * (float)n4 / (float)s6;
                    break;
                }
                case 764: {
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    ((MetaRecord)object).addElement(this.readShort(dataInputStream));
                    int n4 = this.readInt(dataInputStream);
                    int n21 = n4 & 0xFF;
                    int n22 = n4 >> 8 & 0xFF;
                    int n9 = n4 >> 16 & 0xFF;
                    ((MetaRecord)object).addElement(n21);
                    ((MetaRecord)object).addElement(n22);
                    ((MetaRecord)object).addElement(n9);
                    ((MetaRecord)object).addElement(this.readShort(dataInputStream));
                    this.records.add(object);
                    break;
                }
                case 762: {
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    ((MetaRecord)object).addElement(this.readShort(dataInputStream));
                    int n4 = this.readInt(dataInputStream);
                    int n23 = this.readInt(dataInputStream);
                    if (n3 == 6) {
                        this.readShort(dataInputStream);
                    }
                    int n24 = n23 & 0xFF;
                    int n9 = n23 >> 8 & 0xFF;
                    int n10 = n23 >> 16 & 0xFF;
                    ((MetaRecord)object).addElement(n24);
                    ((MetaRecord)object).addElement(n9);
                    ((MetaRecord)object).addElement(n10);
                    ((MetaRecord)object).addElement(n4);
                    this.records.add(object);
                    break;
                }
                case 302: {
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    int n4 = this.readShort(dataInputStream);
                    if (n3 > 1) {
                        for (int i4 = 1; i4 < n3; ++i4) {
                            this.readShort(dataInputStream);
                        }
                    }
                    ((MetaRecord)object).addElement(n4);
                    this.records.add(object);
                    break;
                }
                case 513: 
                case 521: {
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    int n4 = this.readInt(dataInputStream);
                    int n25 = n4 & 0xFF;
                    int n26 = n4 >> 8 & 0xFF;
                    int n9 = n4 >> 16 & 0xFF;
                    ((MetaRecord)object).addElement(n25);
                    ((MetaRecord)object).addElement(n26);
                    ((MetaRecord)object).addElement(n9);
                    this.records.add(object);
                    break;
                }
                case 531: 
                case 532: {
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    int n4 = this.readShort(dataInputStream) * this.ySign;
                    int n27 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    ((MetaRecord)object).addElement(n27);
                    ((MetaRecord)object).addElement(n4);
                    this.records.add(object);
                    break;
                }
                case 262: {
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    int n4 = this.readShort(dataInputStream);
                    if (n3 > 1) {
                        for (int i5 = 1; i5 < n3; ++i5) {
                            this.readShort(dataInputStream);
                        }
                    }
                    ((MetaRecord)object).addElement(n4);
                    this.records.add(object);
                    break;
                }
                case 1336: {
                    int n11;
                    int n10;
                    int n9;
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    short s8 = this.readShort(dataInputStream);
                    int n4 = s8;
                    int[] nArray = new int[s8];
                    for (n9 = 0; n9 < n4; ++n9) {
                        nArray[n9] = this.readShort(dataInputStream);
                    }
                    ((MetaRecord)object).addElement(n4);
                    for (n9 = 0; n9 < n4; ++n9) {
                        ((MetaRecord)object).addElement(nArray[n9]);
                    }
                    for (n10 = 0; n10 < n4; ++n10) {
                        n11 = nArray[n10];
                        for (int i6 = 0; i6 < n11; ++i6) {
                            ((MetaRecord)object).addElement((int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY));
                            ((MetaRecord)object).addElement(this.readShort(dataInputStream) * this.ySign);
                        }
                    }
                    this.records.add(object);
                    break;
                }
                case 804: 
                case 805: {
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    int n4 = this.readShort(dataInputStream);
                    ((MetaRecord)object).addElement(n4);
                    for (int i7 = 0; i7 < n4; ++i7) {
                        ((MetaRecord)object).addElement((int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY));
                        ((MetaRecord)object).addElement(this.readShort(dataInputStream) * this.ySign);
                    }
                    this.records.add(object);
                    break;
                }
                case 1046: 
                case 1048: 
                case 1051: {
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    int n4 = this.readShort(dataInputStream) * this.ySign;
                    int n28 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n29 = this.readShort(dataInputStream) * this.ySign;
                    int n9 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    ((MetaRecord)object).addElement(n9);
                    ((MetaRecord)object).addElement(n29);
                    ((MetaRecord)object).addElement(n28);
                    ((MetaRecord)object).addElement(n4);
                    this.records.add(object);
                    break;
                }
                case 1791: {
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    int n4 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n30 = this.readShort(dataInputStream) * this.ySign;
                    int n31 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n9 = this.readShort(dataInputStream) * this.ySign;
                    ((MetaRecord)object).addElement(n4);
                    ((MetaRecord)object).addElement(n30);
                    ((MetaRecord)object).addElement(n31);
                    ((MetaRecord)object).addElement(n9);
                    this.records.add(object);
                    break;
                }
                case 1564: {
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    int n4 = this.readShort(dataInputStream) * this.ySign;
                    int n32 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n33 = this.readShort(dataInputStream) * this.ySign;
                    int n9 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n10 = this.readShort(dataInputStream) * this.ySign;
                    int n11 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    ((MetaRecord)object).addElement(n11);
                    ((MetaRecord)object).addElement(n10);
                    ((MetaRecord)object).addElement(n9);
                    ((MetaRecord)object).addElement(n33);
                    ((MetaRecord)object).addElement(n32);
                    ((MetaRecord)object).addElement(n4);
                    this.records.add(object);
                    break;
                }
                case 2071: 
                case 2074: {
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    int n4 = this.readShort(dataInputStream) * this.ySign;
                    int n34 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n35 = this.readShort(dataInputStream) * this.ySign;
                    int n9 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n10 = this.readShort(dataInputStream) * this.ySign;
                    int n11 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n36 = this.readShort(dataInputStream) * this.ySign;
                    int n13 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    ((MetaRecord)object).addElement(n13);
                    ((MetaRecord)object).addElement(n36);
                    ((MetaRecord)object).addElement(n11);
                    ((MetaRecord)object).addElement(n10);
                    ((MetaRecord)object).addElement(n9);
                    ((MetaRecord)object).addElement(n35);
                    ((MetaRecord)object).addElement(n34);
                    ((MetaRecord)object).addElement(n4);
                    this.records.add(object);
                    break;
                }
                case 1565: {
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    int n4 = this.readInt(dataInputStream);
                    int n37 = this.readShort(dataInputStream) * this.ySign;
                    int n38 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n9 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n10 = this.readShort(dataInputStream) * this.ySign;
                    ((MetaRecord)object).addElement(n4);
                    ((MetaRecord)object).addElement(n37);
                    ((MetaRecord)object).addElement(n38);
                    ((MetaRecord)object).addElement(n10);
                    ((MetaRecord)object).addElement(n9);
                    this.records.add(object);
                    break;
                }
                case 258: {
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    int n4 = this.readShort(dataInputStream);
                    ((MetaRecord)object).addElement(n4);
                    if (n3 > 1) {
                        for (int i8 = 1; i8 < n3; ++i8) {
                            this.readShort(dataInputStream);
                        }
                    }
                    this.records.add(object);
                    break;
                }
                case 260: {
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    int n4 = n3 == 1 ? (int)this.readShort(dataInputStream) : this.readInt(dataInputStream);
                    ((MetaRecord)object).addElement(n4);
                    this.records.add(object);
                    break;
                }
                case 2881: {
                    int n4 = dataInputStream.readInt() & 0xFF;
                    int n39 = this.readShort(dataInputStream) * this.ySign;
                    int n40 = this.readShort(dataInputStream) * this.xSign;
                    int n9 = this.readShort(dataInputStream) * this.ySign;
                    int n10 = this.readShort(dataInputStream) * this.xSign;
                    int n11 = this.readShort(dataInputStream) * this.ySign;
                    int n41 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n13 = this.readShort(dataInputStream) * this.ySign;
                    int n14 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n42 = 2 * n3 - 20;
                    object = new byte[n42];
                    for (int i9 = 0; i9 < n42; ++i9) {
                        object[i9] = dataInputStream.readByte();
                    }
                    object = new MetaRecord$ByteRecord((byte[])object);
                    v3.numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    ((MetaRecord)object).addElement(n4);
                    ((MetaRecord)object).addElement(n39);
                    ((MetaRecord)object).addElement(n40);
                    ((MetaRecord)object).addElement(n9);
                    ((MetaRecord)object).addElement(n10);
                    ((MetaRecord)object).addElement(n11);
                    ((MetaRecord)object).addElement(n41);
                    ((MetaRecord)object).addElement(n13);
                    ((MetaRecord)object).addElement(n14);
                    this.records.add(object);
                    break;
                }
                case 3907: {
                    int n6;
                    int n4 = dataInputStream.readInt() & 0xFF;
                    this.readShort(dataInputStream);
                    int n43 = this.readShort(dataInputStream) * this.ySign;
                    int n9 = this.readShort(dataInputStream) * this.xSign;
                    int n10 = this.readShort(dataInputStream) * this.ySign;
                    int n11 = this.readShort(dataInputStream) * this.xSign;
                    int n44 = this.readShort(dataInputStream) * this.ySign;
                    int n13 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n14 = this.readShort(dataInputStream) * this.ySign;
                    int n45 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n46 = 2 * n3 - 22;
                    byte[] byArray = new byte[n46];
                    for (n6 = 0; n6 < n46; ++n6) {
                        byArray[n6] = dataInputStream.readByte();
                    }
                    object = new MetaRecord$ByteRecord(byArray);
                    new MetaRecord$ByteRecord(byArray).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    ((MetaRecord)object).addElement(n4);
                    ((MetaRecord)object).addElement(n43);
                    ((MetaRecord)object).addElement(n9);
                    ((MetaRecord)object).addElement(n10);
                    ((MetaRecord)object).addElement(n11);
                    ((MetaRecord)object).addElement(n44);
                    ((MetaRecord)object).addElement(n13);
                    ((MetaRecord)object).addElement(n14);
                    ((MetaRecord)object).addElement(n45);
                    this.records.add(object);
                    break;
                }
                case 2368: {
                    int n4 = dataInputStream.readInt() & 0xFF;
                    short s9 = this.readShort(dataInputStream);
                    short s10 = this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    int n10 = this.readShort(dataInputStream);
                    int n11 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    short s11 = this.readShort(dataInputStream);
                    int n13 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n14 = 2 * n3 - 18;
                    if (n14 > 0) {
                        byte[] byArray = new byte[n14];
                        for (int i10 = 0; i10 < n14; ++i10) {
                            byArray[i10] = dataInputStream.readByte();
                        }
                        object = new MetaRecord$ByteRecord(byArray);
                        new MetaRecord$ByteRecord(byArray).numPoints = n3;
                        ((MetaRecord)object).functionId = n2;
                    } else {
                        ((MetaRecord)object).numPoints = n3;
                        ((MetaRecord)object).functionId = n2;
                        for (int i11 = 0; i11 < n14; ++i11) {
                            dataInputStream.readByte();
                        }
                    }
                    ((MetaRecord)object).addElement(n4);
                    ((MetaRecord)object).addElement(n10);
                    ((MetaRecord)object).addElement(n11);
                    ((MetaRecord)object).addElement(s9);
                    ((MetaRecord)object).addElement(s10);
                    ((MetaRecord)object).addElement(s11);
                    ((MetaRecord)object).addElement(n13);
                    this.records.add(object);
                    break;
                }
                case 322: {
                    int n9;
                    int n4 = dataInputStream.readInt() & 0xFF;
                    int n47 = 2 * n3 - 4;
                    byte[] byArray = new byte[n47];
                    for (n9 = 0; n9 < n47; ++n9) {
                        byArray[n9] = dataInputStream.readByte();
                    }
                    object = new MetaRecord$ByteRecord(byArray);
                    new MetaRecord$ByteRecord(byArray).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    ((MetaRecord)object).addElement(n4);
                    this.records.add(object);
                    break;
                }
                default: {
                    int n4;
                    ((MetaRecord)object).numPoints = n3;
                    ((MetaRecord)object).functionId = n2;
                    for (n4 = 0; n4 < n3; ++n4) {
                        ((MetaRecord)object).addElement(this.readShort(dataInputStream));
                    }
                    this.records.add(object);
                }
            }
            ++this.numRecords;
        }
        if (!this.isAldus) {
            this.right = (int)this.vpX;
            this.left = (int)(this.vpX + (float)this.vpW);
            this.top = (int)this.vpY;
            this.bottom = (int)(this.vpY + (float)this.vpH);
        }
        this.setReading(false);
        return true;
    }

    public URL getUrl() {
        return this.a;
    }

    public void setUrl(URL uRL) {
        this.a = uRL;
    }

    public MetaRecord getRecord(int n2) {
        return (MetaRecord)this.records.get(n2);
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public float getVpX() {
        return this.vpX;
    }

    public float getVpY() {
        return this.vpY;
    }

    public void setVpX(float f2) {
        this.vpX = f2;
    }

    public void setVpY(float f2) {
        this.vpY = f2;
    }
}

