/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.batik.ext.awt.geom.Polygon2D;
import org.apache.batik.ext.awt.geom.Polyline2D;
import org.apache.batik.transcoder.wmf.tosvg.AbstractWMFReader;
import org.apache.batik.transcoder.wmf.tosvg.GdiObject;
import org.apache.batik.transcoder.wmf.tosvg.WMFFont;
import org.apache.batik.transcoder.wmf.tosvg.WMFUtilities;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WMFHeaderProperties
extends AbstractWMFReader {
    private static final Integer a = new Integer(0);
    protected DataInputStream stream;
    private int a;
    private int b;
    private int c;
    private int d;
    private int e;
    private int f;
    private int g;
    private int h;
    private int i;
    private int j;
    private float a;
    private int k = 0;
    private int l = 0;
    private int m = 0;
    private WMFFont a;
    private static final FontRenderContext a = new FontRenderContext(new AffineTransform(), false, true);
    private transient boolean a = true;
    public static final int PEN = 1;
    public static final int BRUSH = 2;
    public static final int FONT = 3;
    public static final int NULL_PEN = 4;
    public static final int NULL_BRUSH = 5;
    public static final int PALETTE = 6;
    public static final int OBJ_BITMAP = 7;
    public static final int OBJ_REGION = 8;

    public WMFHeaderProperties(File file) {
        this.reset();
        this.stream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        this.read(this.stream);
        this.stream.close();
    }

    public WMFHeaderProperties() {
    }

    public void closeResource() {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void setFile(File file) {
        this.stream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        this.read(this.stream);
        this.stream.close();
    }

    @Override
    public void reset() {
        this.left = 0;
        this.right = 0;
        this.top = 1000;
        this.bottom = 1000;
        this.inch = 84;
        this.a = -1;
        this.b = -1;
        this.c = -1;
        this.d = -1;
        this.g = -1;
        this.h = -1;
        this.i = -1;
        this.j = -1;
        this.e = -1;
        this.f = -1;
        this.vpW = -1;
        this.vpH = -1;
        this.vpX = 0;
        this.vpY = 0;
        this.k = 0;
        this.l = 0;
        this.scaleXY = 1.0f;
        this.a = true;
    }

    public DataInputStream getStream() {
        return this.stream;
    }

    @Override
    protected boolean readRecords(DataInputStream dataInputStream) {
        int n2 = 1;
        int n3 = -1;
        int n4 = -1;
        block34: while (n2 > 0) {
            int n5 = this.readInt(dataInputStream);
            n5 -= 3;
            short s2 = this.readShort(dataInputStream);
            n2 = s2;
            if (s2 <= 0) break;
            switch (n2) {
                case 259: {
                    short s3 = this.readShort(dataInputStream);
                    if (s3 != 8) continue block34;
                    this.isotropic = false;
                    continue block34;
                }
                case 523: {
                    this.vpY = this.readShort(dataInputStream);
                    this.vpX = this.readShort(dataInputStream);
                    continue block34;
                }
                case 524: {
                    this.vpH = this.readShort(dataInputStream);
                    this.vpW = this.readShort(dataInputStream);
                    if (!this.isotropic) {
                        this.scaleXY = (float)this.vpW / (float)this.vpH;
                    }
                    this.vpW = (int)((float)this.vpW * this.scaleXY);
                    continue block34;
                }
                case 762: {
                    short s4 = this.readShort(dataInputStream);
                    this.readInt(dataInputStream);
                    int n6 = this.readInt(dataInputStream);
                    int n7 = n6 & 0xFF;
                    int n8 = n6 >> 8 & 0xFF;
                    int n9 = n6 >> 16 & 0xFF;
                    Color color = new Color(n7, n8, n9);
                    if (n5 == 6) {
                        this.readShort(dataInputStream);
                    }
                    if (s4 == 5) {
                        this.addObjectAt(4, color, 0);
                        continue block34;
                    }
                    this.addObjectAt(1, color, 0);
                    continue block34;
                }
                case 764: {
                    short s5 = this.readShort(dataInputStream);
                    int n10 = this.readInt(dataInputStream);
                    int n11 = n10 & 0xFF;
                    int n12 = n10 >> 8 & 0xFF;
                    int n13 = n10 >> 16 & 0xFF;
                    Color color = new Color(n11, n12, n13);
                    this.readShort(dataInputStream);
                    if (s5 == 5) {
                        this.addObjectAt(5, color, 0);
                        continue block34;
                    }
                    this.addObjectAt(2, color, 0);
                    continue block34;
                }
                case 302: {
                    short s6 = this.readShort(dataInputStream);
                    if (n5 > 1) {
                        for (int i2 = 1; i2 < n5; ++i2) {
                            this.readShort(dataInputStream);
                        }
                    }
                    WMFUtilities.getHorizontalAlignment(s6);
                    this.m = WMFUtilities.getVerticalAlignment(s6);
                    continue block34;
                }
                case 2610: {
                    short s7 = this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    int n14 = this.readShort(dataInputStream);
                    int n15 = this.readShort(dataInputStream);
                    int n16 = 4;
                    if ((n15 & 4) != 0) {
                        this.readShort(dataInputStream);
                        this.readShort(dataInputStream);
                        this.readShort(dataInputStream);
                        this.readShort(dataInputStream);
                        n16 += 4;
                    }
                    Object object = new byte[n14];
                    for (n15 = 0; n15 < n14; ++n15) {
                        object[n15] = dataInputStream.readByte();
                    }
                    object = WMFUtilities.decodeString(this.a, object);
                    n16 += (n14 + 1) / 2;
                    if (n14 % 2 != 0) {
                        dataInputStream.readByte();
                    }
                    if (n16 < n5) {
                        for (int i3 = n16; i3 < n5; ++i3) {
                            this.readShort(dataInputStream);
                        }
                    }
                    TextLayout textLayout = new TextLayout((String)object, this.a.font, a);
                    n5 = (int)textLayout.getBounds().getWidth();
                    int n17 = (int)textLayout.getBounds().getX();
                    int n18 = (int)WMFHeaderProperties.a(textLayout, this.m);
                    this.a(n17, s7);
                    this.a(n17 + n5, s7 + n18);
                    this.a = false;
                    continue block34;
                }
                case 1313: 
                case 1583: {
                    int n19 = this.readShort(dataInputStream);
                    byte[] byArray = new byte[n19];
                    for (int i4 = 0; i4 < n19; ++i4) {
                        byArray[i4] = dataInputStream.readByte();
                    }
                    String string = WMFUtilities.decodeString(this.a, byArray);
                    if (n19 % 2 != 0) {
                        dataInputStream.readByte();
                    }
                    int n20 = 1 + (n19 + 1) / 2;
                    short s8 = this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    if ((n20 += 2) < n5) {
                        for (int i5 = n20; i5 < n5; ++i5) {
                            this.readShort(dataInputStream);
                        }
                    }
                    TextLayout textLayout = new TextLayout(string, this.a.font, a);
                    int n21 = (int)textLayout.getBounds().getWidth();
                    int n22 = (int)textLayout.getBounds().getX();
                    n19 = (int)WMFHeaderProperties.a(textLayout, this.m);
                    this.a(n22, s8);
                    this.a(n22 + n21, s8 + n19);
                    continue block34;
                }
                case 763: {
                    short s9 = this.readShort(dataInputStream);
                    float f2 = (int)(this.scaleY * (float)s9);
                    this.readShort(dataInputStream);
                    short s10 = this.readShort(dataInputStream);
                    short s11 = this.readShort(dataInputStream);
                    short s12 = this.readShort(dataInputStream);
                    byte by2 = dataInputStream.readByte();
                    int n21 = dataInputStream.readByte();
                    s9 = dataInputStream.readByte();
                    int n23 = dataInputStream.readByte() & 0xFF;
                    dataInputStream.readByte();
                    dataInputStream.readByte();
                    dataInputStream.readByte();
                    dataInputStream.readByte();
                    int n24 = by2 > 0 ? 2 : 0;
                    n24 = n24 | (s12 > 400 ? 1 : 0);
                    n5 = 2 * (n5 - 9);
                    byte[] byArray = new byte[n5];
                    for (int i6 = 0; i6 < n5; ++i6) {
                        byArray[i6] = dataInputStream.readByte();
                    }
                    String string = new String(byArray);
                    for (n5 = 0; n5 < string.length() && (Character.isLetterOrDigit(string.charAt(n5)) || Character.isWhitespace(string.charAt(n5))); ++n5) {
                    }
                    string = n5 > 0 ? string.substring(0, n5) : "System";
                    if (f2 < 0.0f) {
                        f2 = -f2;
                    }
                    Object object = new Font(string, n24, (int)f2);
                    object = ((Font)object).deriveFont(f2);
                    object = new WMFFont((Font)object, n23, n21, s9, by2, s12, s11, s10);
                    this.addObjectAt(3, object, 0);
                    continue block34;
                }
                case 1791: {
                    for (int i7 = 0; i7 < n5; ++i7) {
                        this.readShort(dataInputStream);
                    }
                    this.addObjectAt(6, a, 0);
                    continue block34;
                }
                case 247: {
                    for (int i8 = 0; i8 < n5; ++i8) {
                        this.readShort(dataInputStream);
                    }
                    this.addObjectAt(8, a, 0);
                    continue block34;
                }
                case 301: {
                    short s13 = this.readShort(dataInputStream);
                    n5 = s13;
                    if ((s13 & Integer.MIN_VALUE) != 0) continue block34;
                    GdiObject gdiObject = this.getObject(n5);
                    if (!gdiObject.a) continue block34;
                    switch (gdiObject.a) {
                        case 1: {
                            n4 = n5;
                            continue block34;
                        }
                        case 2: {
                            n3 = n5;
                            continue block34;
                        }
                        case 3: {
                            this.a = (WMFFont)gdiObject.a;
                            continue block34;
                        }
                        case 4: {
                            n4 = -1;
                            continue block34;
                        }
                        case 5: {
                            n3 = -1;
                        }
                    }
                    continue block34;
                }
                case 496: {
                    n5 = this.readShort(dataInputStream);
                    GdiObject gdiObject = this.getObject(n5);
                    if (n5 == n3) {
                        n3 = -1;
                    } else if (n5 == n4) {
                        n4 = -1;
                    }
                    gdiObject.clear();
                    continue block34;
                }
                case 531: {
                    short s14 = this.readShort(dataInputStream);
                    int n25 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    if (n4 >= 0) {
                        this.a(this.k, this.l);
                        this.a(n25, s14);
                        this.a = false;
                    }
                    this.k = n25;
                    this.l = s14;
                    continue block34;
                }
                case 532: {
                    this.l = this.readShort(dataInputStream);
                    this.k = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    continue block34;
                }
                case 1336: {
                    int n21;
                    int n26 = this.readShort(dataInputStream);
                    int[] nArray = new int[n26];
                    for (int i9 = 0; i9 < n26; ++i9) {
                        nArray[i9] = this.readShort(dataInputStream);
                    }
                    for (int i10 = 0; i10 < n26; ++i10) {
                        for (int i11 = 0; i11 < nArray[i10]; ++i11) {
                            int n27 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                            n21 = this.readShort(dataInputStream);
                            if (n3 < 0 && n4 < 0) continue;
                            this.a(n27, n21);
                        }
                    }
                    this.a = false;
                    continue block34;
                }
                case 804: {
                    int n28 = this.readShort(dataInputStream);
                    float[] fArray = new float[n28 + 1];
                    float[] fArray2 = new float[n28 + 1];
                    for (int i12 = 0; i12 < n28; ++i12) {
                        fArray[i12] = (float)this.readShort(dataInputStream) * this.scaleXY;
                        fArray2[i12] = this.readShort(dataInputStream);
                    }
                    fArray[n28] = fArray[0];
                    fArray2[n28] = fArray2[0];
                    Polygon2D polygon2D = new Polygon2D(fArray, fArray2, n28);
                    this.a(n3, n4, polygon2D);
                    continue block34;
                }
                case 805: {
                    Polyline2D polyline2D;
                    int n29 = this.readShort(dataInputStream);
                    float[] fArray = new float[n29];
                    float[] fArray3 = new float[n29];
                    for (int i13 = 0; i13 < n29; ++i13) {
                        fArray[i13] = (float)this.readShort(dataInputStream) * this.scaleXY;
                        fArray3[i13] = this.readShort(dataInputStream);
                    }
                    Polyline2D polyline2D2 = polyline2D = new Polyline2D(fArray, fArray3, n29);
                    int n30 = n4;
                    WMFHeaderProperties wMFHeaderProperties = this;
                    if (n30 < 0) continue block34;
                    Serializable serializable = wMFHeaderProperties.a(n30);
                    if (wMFHeaderProperties.a && ((Color)serializable).equals(Color.white)) continue block34;
                    serializable = polyline2D2.getBounds();
                    wMFHeaderProperties.a((int)((RectangularShape)((Object)serializable)).getMinX(), (int)((RectangularShape)((Object)serializable)).getMinY());
                    wMFHeaderProperties.a((int)((RectangularShape)((Object)serializable)).getMaxX(), (int)((RectangularShape)((Object)serializable)).getMaxY());
                    wMFHeaderProperties.a = false;
                    continue block34;
                }
                case 1046: 
                case 1048: 
                case 1051: {
                    short s15 = this.readShort(dataInputStream);
                    int n31 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    short s16 = this.readShort(dataInputStream);
                    int n32 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    Rectangle2D.Float float_ = new Rectangle2D.Float(n32, s16, n31 - n32, s15 - s16);
                    this.a(n3, n4, float_);
                    continue block34;
                }
                case 1564: {
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    short s17 = this.readShort(dataInputStream);
                    int n33 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    short s18 = this.readShort(dataInputStream);
                    int n34 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    Rectangle2D.Float float_ = new Rectangle2D.Float(n34, s18, n33 - n34, s17 - s18);
                    this.a(n3, n4, float_);
                    continue block34;
                }
                case 2071: 
                case 2074: 
                case 2096: {
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    short s19 = this.readShort(dataInputStream);
                    int n35 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    short s20 = this.readShort(dataInputStream);
                    int n36 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    Rectangle2D.Float float_ = new Rectangle2D.Float(n36, s20, n35 - n36, s19 - s20);
                    this.a(n3, n4, float_);
                    continue block34;
                }
                case 1565: {
                    this.readInt(dataInputStream);
                    short s21 = this.readShort(dataInputStream);
                    int n37 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    int n38 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    short s22 = this.readShort(dataInputStream);
                    if (n4 >= 0) {
                        this.a(n38, s22);
                    }
                    if (n4 < 0) continue block34;
                    this.a(n38 + n37, s22 + s21);
                    continue block34;
                }
                case 2881: {
                    dataInputStream.readInt();
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    float f3 = this.readShort(dataInputStream);
                    float f4 = (float)this.readShort(dataInputStream) * this.scaleXY;
                    float f5 = (float)this.readShort(dataInputStream) * this.getVpWFactor() * (float)this.inch / PIXEL_PER_INCH;
                    float f6 = (float)this.readShort(dataInputStream) * this.getVpWFactor() * (float)this.inch / PIXEL_PER_INCH * this.scaleXY;
                    f4 = f4 * this.getVpWFactor() * (float)this.inch / PIXEL_PER_INCH;
                    f3 = f3 * this.getVpHFactor() * (float)this.inch / PIXEL_PER_INCH;
                    this.b((int)f6, (int)f5);
                    this.b((int)(f6 + f4), (int)(f5 + f3));
                    int n39 = 2 * n5 - 20;
                    for (int i14 = 0; i14 < n39; ++i14) {
                        dataInputStream.readByte();
                    }
                    continue block34;
                }
                case 3907: {
                    dataInputStream.readInt();
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    float f7 = this.readShort(dataInputStream);
                    float f8 = (float)this.readShort(dataInputStream) * this.scaleXY;
                    float f9 = (float)this.readShort(dataInputStream) * this.getVpHFactor() * (float)this.inch / PIXEL_PER_INCH;
                    float f10 = (float)this.readShort(dataInputStream) * this.getVpHFactor() * (float)this.inch / PIXEL_PER_INCH * this.scaleXY;
                    f8 = f8 * this.getVpWFactor() * (float)this.inch / PIXEL_PER_INCH;
                    f7 = f7 * this.getVpHFactor() * (float)this.inch / PIXEL_PER_INCH;
                    this.b((int)f10, (int)f9);
                    this.b((int)(f10 + f8), (int)(f9 + f7));
                    int n40 = 2 * n5 - 22;
                    byte[] byArray = new byte[n40];
                    for (int i15 = 0; i15 < n40; ++i15) {
                        byArray[i15] = dataInputStream.readByte();
                    }
                    continue block34;
                }
                case 2368: {
                    dataInputStream.readInt();
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    float f11 = (float)this.readShort(dataInputStream) * (float)this.inch / PIXEL_PER_INCH * this.getVpHFactor();
                    float f12 = (float)this.readShort(dataInputStream) * (float)this.inch / PIXEL_PER_INCH * this.getVpWFactor() * this.scaleXY;
                    float f13 = (float)this.inch / PIXEL_PER_INCH * this.getVpHFactor() * (float)this.readShort(dataInputStream);
                    float f14 = (float)this.inch / PIXEL_PER_INCH * this.getVpWFactor() * (float)this.readShort(dataInputStream) * this.scaleXY;
                    this.b((int)f14, (int)f13);
                    this.b((int)(f14 + f12), (int)(f13 + f11));
                    continue block34;
                }
            }
            for (int i16 = 0; i16 < n5; ++i16) {
                this.readShort(dataInputStream);
            }
        }
        if (!this.isAldus) {
            this.width = this.vpW;
            this.height = this.vpH;
            this.right = this.vpX;
            this.left = this.vpX + this.vpW;
            this.top = this.vpY;
            this.bottom = this.vpY + this.vpH;
        }
        WMFHeaderProperties wMFHeaderProperties = this;
        this.a = (float)wMFHeaderProperties.getWidthPixels() / (float)wMFHeaderProperties.vpW;
        if (wMFHeaderProperties.b != -1) {
            wMFHeaderProperties.b = (int)(wMFHeaderProperties.a * (float)(wMFHeaderProperties.vpX + wMFHeaderProperties.b));
            wMFHeaderProperties.a = (int)(wMFHeaderProperties.a * (float)(wMFHeaderProperties.vpX + wMFHeaderProperties.a));
            wMFHeaderProperties.d = (int)(wMFHeaderProperties.a * (float)(wMFHeaderProperties.vpY + wMFHeaderProperties.d));
            wMFHeaderProperties.c = (int)(wMFHeaderProperties.a * (float)(wMFHeaderProperties.vpY + wMFHeaderProperties.c));
        }
        if (wMFHeaderProperties.h != -1) {
            wMFHeaderProperties.h = (int)((float)wMFHeaderProperties.h * (float)wMFHeaderProperties.getWidthPixels() / (float)wMFHeaderProperties.width);
            wMFHeaderProperties.g = (int)((float)wMFHeaderProperties.g * (float)wMFHeaderProperties.getWidthPixels() / (float)wMFHeaderProperties.width);
            wMFHeaderProperties.j = (int)((float)wMFHeaderProperties.j * (float)wMFHeaderProperties.getWidthPixels() / (float)wMFHeaderProperties.width);
            wMFHeaderProperties.i = (int)((float)wMFHeaderProperties.i * (float)wMFHeaderProperties.getWidthPixels() / (float)wMFHeaderProperties.width);
            if (wMFHeaderProperties.b == -1 || wMFHeaderProperties.h > wMFHeaderProperties.b) {
                wMFHeaderProperties.b = wMFHeaderProperties.h;
            }
            if (wMFHeaderProperties.a == -1 || wMFHeaderProperties.g < wMFHeaderProperties.a) {
                wMFHeaderProperties.a = wMFHeaderProperties.g;
            }
            if (wMFHeaderProperties.c == -1 || wMFHeaderProperties.i < wMFHeaderProperties.c) {
                wMFHeaderProperties.c = wMFHeaderProperties.i;
            }
            if (wMFHeaderProperties.d == -1 || wMFHeaderProperties.j > wMFHeaderProperties.d) {
                wMFHeaderProperties.d = wMFHeaderProperties.j;
            }
        }
        if (wMFHeaderProperties.a != -1 && wMFHeaderProperties.b != -1) {
            wMFHeaderProperties.e = wMFHeaderProperties.b - wMFHeaderProperties.a;
        }
        if (wMFHeaderProperties.c != -1 && wMFHeaderProperties.d != -1) {
            wMFHeaderProperties.f = wMFHeaderProperties.d - wMFHeaderProperties.c;
        }
        return true;
    }

    public int getWidthBoundsPixels() {
        return this.e;
    }

    public int getHeightBoundsPixels() {
        return this.f;
    }

    public int getWidthBoundsUnits() {
        return (int)((float)this.inch * (float)this.e / PIXEL_PER_INCH);
    }

    public int getHeightBoundsUnits() {
        return (int)((float)this.inch * (float)this.f / PIXEL_PER_INCH);
    }

    public int getXOffset() {
        return this.a;
    }

    public int getYOffset() {
        return this.c;
    }

    private void a(int n2, int n3) {
        if (this.a == -1) {
            this.a = n2;
        } else if (n2 < this.a) {
            this.a = n2;
        }
        if (this.b == -1) {
            this.b = n2;
        } else if (n2 > this.b) {
            this.b = n2;
        }
        if (this.c == -1) {
            this.c = n3;
        } else if (n3 < this.c) {
            this.c = n3;
        }
        if (this.d == -1) {
            this.d = n3;
            return;
        }
        if (n3 > this.d) {
            this.d = n3;
        }
    }

    private void b(int n2, int n3) {
        if (this.g == -1) {
            this.g = n2;
        } else if (n2 < this.g) {
            this.g = n2;
        }
        if (this.h == -1) {
            this.h = n2;
        } else if (n2 > this.h) {
            this.h = n2;
        }
        if (this.i == -1) {
            this.i = n3;
        } else if (n3 < this.i) {
            this.i = n3;
        }
        if (this.j == -1) {
            this.j = n3;
            return;
        }
        if (n3 > this.j) {
            this.j = n3;
        }
    }

    private Color a(int n2) {
        if (n2 >= 0) {
            GdiObject gdiObject = this.getObject(n2);
            return (Color)gdiObject.a;
        }
        return null;
    }

    private void a(int n2, int n3, Shape shape) {
        if (n2 >= 0 || n3 >= 0) {
            Serializable serializable = n2 >= 0 ? this.a(n2) : this.a(n3);
            if (!this.a || !((Color)serializable).equals(Color.white)) {
                serializable = shape.getBounds();
                this.a((int)((RectangularShape)((Object)serializable)).getMinX(), (int)((RectangularShape)((Object)serializable)).getMinY());
                this.a((int)((RectangularShape)((Object)serializable)).getMaxX(), (int)((RectangularShape)((Object)serializable)).getMaxY());
                this.a = false;
            }
        }
    }

    private static float a(TextLayout textLayout, int n2) {
        if (n2 == 24) {
            return -textLayout.getAscent();
        }
        if (n2 == 0) {
            return textLayout.getAscent() + textLayout.getDescent();
        }
        return 0.0f;
    }
}

