/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import org.apache.batik.transcoder.wmf.tosvg.WMFFont;
import org.apache.batik.transcoder.wmf.tosvg.WMFRecordStore;

public class AbstractWMFPainter {
    public static final String WMF_FILE_EXTENSION = ".wmf";
    protected WMFFont wmfFont = null;
    protected int currentHorizAlign = 0;
    protected int currentVertAlign = 0;
    public static final int PEN = 1;
    public static final int BRUSH = 2;
    public static final int FONT = 3;
    public static final int NULL_PEN = 4;
    public static final int NULL_BRUSH = 5;
    public static final int PALETTE = 6;
    public static final int OBJ_BITMAP = 7;
    public static final int OBJ_REGION = 8;
    protected WMFRecordStore currentStore;
    protected transient boolean bReadingWMF = true;
    protected transient BufferedInputStream bufStream = null;

    protected BufferedImage getImage(byte[] byArray, int n2, int n3) {
        int n4 = (byArray[7] & 0xFF) << 24 | (byArray[6] & 0xFF) << 16 | (byArray[5] & 0xFF) << 8 | byArray[4] & 0xFF;
        int n5 = (byArray[11] & 0xFF) << 24 | (byArray[10] & 0xFF) << 16 | (byArray[9] & 0xFF) << 8 | byArray[8] & 0xFF;
        if (n2 != n4 || n3 != n5) {
            return null;
        }
        return this.getImage(byArray);
    }

    protected Dimension getImageDimension(byte[] byArray) {
        int n2 = (byArray[7] & 0xFF) << 24 | (byArray[6] & 0xFF) << 16 | (byArray[5] & 0xFF) << 8 | byArray[4] & 0xFF;
        int n3 = (byArray[11] & 0xFF) << 24 | (byArray[10] & 0xFF) << 16 | (byArray[9] & 0xFF) << 8 | byArray[8] & 0xFF;
        return new Dimension(n2, n3);
    }

    protected BufferedImage getImage(byte[] byArray) {
        int n2 = (byArray[7] & 0xFF) << 24 | (byArray[6] & 0xFF) << 16 | (byArray[5] & 0xFF) << 8 | byArray[4] & 0xFF;
        int n3 = (byArray[11] & 0xFF) << 24 | (byArray[10] & 0xFF) << 16 | (byArray[9] & 0xFF) << 8 | byArray[8] & 0xFF;
        int[] nArray = new int[n2 * n3];
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n4 = (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        int n5 = (byArray[15] & 0xFF) << 8 | byArray[14] & 0xFF;
        int n6 = (byArray[23] & 0xFF) << 24 | (byArray[22] & 0xFF) << 16 | (byArray[21] & 0xFF) << 8 | byArray[20] & 0xFF;
        if (n6 == 0) {
            n6 = ((n2 * n5 + 31 & 0xFFFFFFE0) >> 3) * n3;
        }
        int n7 = (byArray[35] & 0xFF) << 24 | (byArray[34] & 0xFF) << 16 | (byArray[33] & 0xFF) << 8 | byArray[32] & 0xFF;
        if (n5 == 24) {
            n5 = n6 / n3 - n2 * 3;
            for (n7 = 0; n7 < n3; ++n7) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    nArray[n2 * (n3 - n7 - 1) + i2] = 0xFF000000 | (byArray[n4 + 2] & 0xFF) << 16 | (byArray[n4 + 1] & 0xFF) << 8 | byArray[n4] & 0xFF;
                    n4 += 3;
                }
                n4 += n5;
            }
        } else if (n5 == 8) {
            int n8;
            n5 = n7 > 0 ? n7 : 256;
            int[] nArray2 = new int[n5];
            for (n8 = 0; n8 < n5; ++n8) {
                nArray2[n8] = 0xFF000000 | (byArray[n4 + 2] & 0xFF) << 16 | (byArray[n4 + 1] & 0xFF) << 8 | byArray[n4] & 0xFF;
                n4 += 4;
            }
            n6 = byArray.length - n4;
            n8 = n6 / n3 - n2;
            for (n5 = 0; n5 < n3; ++n5) {
                for (n6 = 0; n6 < n2; ++n6) {
                    nArray[n2 * (n3 - n5 - 1) + n6] = nArray2[byArray[n4] & 0xFF];
                    ++n4;
                }
                n4 += n8;
            }
        } else if (n5 == 1) {
            int n9;
            int[] nArray3 = new int[2];
            for (n9 = 0; n9 < 2; ++n9) {
                nArray3[n9] = 0xFF000000 | (byArray[n4 + 2] & 0xFF) << 16 | (byArray[n4 + 1] & 0xFF) << 8 | byArray[n4] & 0xFF;
                n4 += 4;
            }
            n9 = 7;
            n5 = byArray[n4];
            n6 = n6 / n3 - n2 / 8;
            for (int i3 = 0; i3 < n3; ++i3) {
                for (int i4 = 0; i4 < n2; ++i4) {
                    nArray[n2 * (n3 - i3 - 1) + i4] = (n5 & 1 << n9) != 0 ? nArray3[1] : nArray3[0];
                    if (--n9 != -1) continue;
                    n9 = 7;
                    if (++n4 >= byArray.length) continue;
                    n5 = byArray[n4];
                }
                n9 = 7;
                if ((n4 += n6) >= byArray.length) continue;
                n5 = byArray[n4];
            }
        }
        writableRaster.setDataElements(0, 0, n2, n3, nArray);
        return bufferedImage;
    }

    protected AttributedCharacterIterator getCharacterIterator(Graphics2D graphics2D, String string, WMFFont wMFFont) {
        return this.getAttributedString(graphics2D, string, wMFFont).getIterator();
    }

    protected AttributedCharacterIterator getCharacterIterator(Graphics2D object, String string, WMFFont wMFFont, int n2) {
        object = this.getAttributedString((Graphics2D)object, string, wMFFont);
        return ((AttributedString)object).getIterator();
    }

    protected AttributedString getAttributedString(Graphics2D object, String object2, WMFFont wMFFont) {
        object2 = new AttributedString((String)object2);
        object = ((Graphics)object).getFont();
        ((AttributedString)object2).addAttribute(TextAttribute.SIZE, new Float(((Font)object).getSize2D()));
        ((AttributedString)object2).addAttribute(TextAttribute.FONT, object);
        if (this.wmfFont.underline != 0) {
            ((AttributedString)object2).addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (this.wmfFont.italic != 0) {
            ((AttributedString)object2).addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            ((AttributedString)object2).addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
        }
        if (this.wmfFont.weight > 400) {
            ((AttributedString)object2).addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            ((AttributedString)object2).addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        }
        return object2;
    }

    public void setRecordStore(WMFRecordStore wMFRecordStore) {
        if (wMFRecordStore == null) {
            throw new IllegalArgumentException();
        }
        this.currentStore = wMFRecordStore;
    }

    public WMFRecordStore getRecordStore() {
        return this.currentStore;
    }

    protected int addObject(WMFRecordStore wMFRecordStore, int n2, Object object) {
        return this.currentStore.addObject(n2, object);
    }

    protected int addObjectAt(WMFRecordStore wMFRecordStore, int n2, Object object, int n3) {
        return this.currentStore.addObjectAt(n2, object, n3);
    }
}

