/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.apache.batik.ext.awt.geom.Polygon2D;

public class Polyline2D
implements Shape,
Serializable,
Cloneable {
    public int npoints;
    public float[] xpoints;
    public float[] ypoints;
    protected Rectangle2D bounds;
    private GeneralPath a;
    private GeneralPath b;

    public Polyline2D() {
        this.xpoints = new float[4];
        this.ypoints = new float[4];
    }

    public Polyline2D(float[] fArray, float[] fArray2, int n2) {
        if (n2 > fArray.length || n2 > fArray2.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = n2;
        this.xpoints = new float[n2 + 1];
        this.ypoints = new float[n2 + 1];
        System.arraycopy(fArray, 0, this.xpoints, 0, n2);
        System.arraycopy(fArray2, 0, this.ypoints, 0, n2);
        this.a();
    }

    public Polyline2D(int[] nArray, int[] nArray2, int n2) {
        if (n2 > nArray.length || n2 > nArray2.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = n2;
        this.xpoints = new float[n2];
        this.ypoints = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xpoints[i2] = nArray[i2];
            this.ypoints[i2] = nArray2[i2];
        }
        this.a();
    }

    public Polyline2D(Line2D line2D) {
        this.npoints = 2;
        this.xpoints = new float[2];
        this.ypoints = new float[2];
        this.xpoints[0] = (float)line2D.getX1();
        this.xpoints[1] = (float)line2D.getX2();
        this.ypoints[0] = (float)line2D.getY1();
        this.ypoints[1] = (float)line2D.getY2();
        this.a();
    }

    public void reset() {
        this.npoints = 0;
        this.bounds = null;
        this.a = new GeneralPath();
        this.b = null;
    }

    public Object clone() {
        Polyline2D polyline2D = new Polyline2D();
        for (int i2 = 0; i2 < this.npoints; ++i2) {
            polyline2D.addPoint(this.xpoints[i2], this.ypoints[i2]);
        }
        return polyline2D;
    }

    private void a() {
        this.a = new GeneralPath();
        this.a.moveTo(this.xpoints[0], this.ypoints[0]);
        for (int i2 = 1; i2 < this.npoints; ++i2) {
            this.a.lineTo(this.xpoints[i2], this.ypoints[i2]);
        }
        this.bounds = this.a.getBounds2D();
        this.b = null;
    }

    public void addPoint(Point2D point2D) {
        this.addPoint((float)point2D.getX(), (float)point2D.getY());
    }

    public void addPoint(float f2, float f3) {
        if (this.npoints == this.xpoints.length) {
            float[] fArray = new float[this.npoints << 1];
            System.arraycopy(this.xpoints, 0, fArray, 0, this.npoints);
            this.xpoints = fArray;
            fArray = new float[this.npoints << 1];
            System.arraycopy(this.ypoints, 0, fArray, 0, this.npoints);
            this.ypoints = fArray;
        }
        this.xpoints[this.npoints] = f2;
        this.ypoints[this.npoints] = f3;
        ++this.npoints;
        float f4 = f3;
        f3 = f2;
        Polyline2D polyline2D = this;
        this.b = null;
        if (polyline2D.a == null) {
            polyline2D.a = new GeneralPath(0);
            polyline2D.a.moveTo(f3, f4);
            polyline2D.bounds = new Rectangle2D.Float(f3, f4, 0.0f, 0.0f);
            return;
        }
        polyline2D.a.lineTo(f3, f4);
        float f5 = (float)polyline2D.bounds.getMaxX();
        float f6 = (float)polyline2D.bounds.getMaxY();
        float f7 = (float)polyline2D.bounds.getMinX();
        float f8 = (float)polyline2D.bounds.getMinY();
        if (f3 < f7) {
            f7 = f3;
        } else if (f3 > f5) {
            f5 = f3;
        }
        if (f4 < f8) {
            f8 = f4;
        } else if (f4 > f6) {
            f6 = f4;
        }
        polyline2D.bounds = new Rectangle2D.Float(f7, f8, f5 - f7, f6 - f8);
    }

    @Override
    public Rectangle getBounds() {
        if (this.bounds == null) {
            return null;
        }
        return this.bounds.getBounds();
    }

    public boolean contains(Point point) {
        return false;
    }

    @Override
    public boolean contains(double d2, double d3) {
        return false;
    }

    public boolean contains(int n2, int n3) {
        return false;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    @Override
    public boolean contains(Point2D point2D) {
        return false;
    }

    @Override
    public boolean intersects(double d2, double d3, double d4, double d5) {
        if (this.npoints <= 0 || !this.bounds.intersects(d2, d3, d4, d5)) {
            return false;
        }
        Polyline2D polyline2D = this;
        if (polyline2D.npoints > 0 && polyline2D.b == null) {
            polyline2D.b = (GeneralPath)polyline2D.a.clone();
            polyline2D.b.closePath();
        }
        return this.b.intersects(d2, d3, d4, d5);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public boolean contains(double d2, double d3, double d4, double d5) {
        return false;
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return false;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        if (this.a == null) {
            return null;
        }
        return this.a.getPathIterator(affineTransform);
    }

    public Polygon2D getPolygon2D() {
        Polygon2D polygon2D = new Polygon2D();
        for (int i2 = 0; i2 < this.npoints - 1; ++i2) {
            polygon2D.addPoint(this.xpoints[i2], this.ypoints[i2]);
        }
        Point2D.Double double_ = new Point2D.Double(this.xpoints[0], this.ypoints[0]);
        Point2D.Double double_2 = new Point2D.Double(this.xpoints[this.npoints - 1], this.ypoints[this.npoints - 1]);
        if (double_.distance(double_2) > (double)0.001f) {
            polygon2D.addPoint(this.xpoints[this.npoints - 1], this.ypoints[this.npoints - 1]);
        }
        return polygon2D;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return this.a.getPathIterator(affineTransform);
    }
}

