/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.apache.batik.ext.awt.geom.Polyline2D;

public class Polygon2D
implements Shape,
Serializable,
Cloneable {
    public int npoints;
    public float[] xpoints;
    public float[] ypoints;
    protected Rectangle2D bounds;
    private GeneralPath a;
    private GeneralPath b;

    public Polygon2D() {
        this.xpoints = new float[4];
        this.ypoints = new float[4];
    }

    public Polygon2D(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new IndexOutOfBoundsException("null Rectangle");
        }
        this.npoints = 4;
        this.xpoints = new float[4];
        this.ypoints = new float[4];
        this.xpoints[0] = (float)rectangle2D.getMinX();
        this.ypoints[0] = (float)rectangle2D.getMinY();
        this.xpoints[1] = (float)rectangle2D.getMaxX();
        this.ypoints[1] = (float)rectangle2D.getMinY();
        this.xpoints[2] = (float)rectangle2D.getMaxX();
        this.ypoints[2] = (float)rectangle2D.getMaxY();
        this.xpoints[3] = (float)rectangle2D.getMinX();
        this.ypoints[3] = (float)rectangle2D.getMaxY();
        this.a();
    }

    public Polygon2D(Polygon polygon) {
        if (polygon == null) {
            throw new IndexOutOfBoundsException("null Polygon");
        }
        this.npoints = polygon.npoints;
        this.xpoints = new float[polygon.npoints];
        this.ypoints = new float[polygon.npoints];
        for (int i2 = 0; i2 < polygon.npoints; ++i2) {
            this.xpoints[i2] = polygon.xpoints[i2];
            this.ypoints[i2] = polygon.ypoints[i2];
        }
        this.a();
    }

    public Polygon2D(float[] fArray, float[] fArray2, int n2) {
        if (n2 > fArray.length || n2 > fArray2.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = n2;
        this.xpoints = new float[n2];
        this.ypoints = new float[n2];
        System.arraycopy(fArray, 0, this.xpoints, 0, n2);
        System.arraycopy(fArray2, 0, this.ypoints, 0, n2);
        this.a();
    }

    public Polygon2D(int[] nArray, int[] nArray2, int n2) {
        if (n2 > nArray.length || n2 > nArray2.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = n2;
        this.xpoints = new float[n2];
        this.ypoints = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xpoints[i2] = nArray[i2];
            this.ypoints[i2] = nArray2[i2];
        }
        this.a();
    }

    public void reset() {
        this.npoints = 0;
        this.bounds = null;
        this.a = new GeneralPath();
        this.b = null;
    }

    public Object clone() {
        Polygon2D polygon2D = new Polygon2D();
        for (int i2 = 0; i2 < this.npoints; ++i2) {
            polygon2D.addPoint(this.xpoints[i2], this.ypoints[i2]);
        }
        return polygon2D;
    }

    private void a() {
        this.a = new GeneralPath();
        this.a.moveTo(this.xpoints[0], this.ypoints[0]);
        for (int i2 = 1; i2 < this.npoints; ++i2) {
            this.a.lineTo(this.xpoints[i2], this.ypoints[i2]);
        }
        this.bounds = this.a.getBounds2D();
        this.b = null;
    }

    public Polyline2D getPolyline2D() {
        Polyline2D polyline2D = new Polyline2D(this.xpoints, this.ypoints, this.npoints);
        polyline2D.addPoint(this.xpoints[0], this.ypoints[0]);
        return polyline2D;
    }

    public Polygon getPolygon() {
        int[] nArray = new int[this.npoints];
        int[] nArray2 = new int[this.npoints];
        for (int i2 = 0; i2 < this.npoints; ++i2) {
            nArray[i2] = (int)this.xpoints[i2];
            nArray2[i2] = (int)this.ypoints[i2];
        }
        return new Polygon(nArray, nArray2, this.npoints);
    }

    public void addPoint(Point2D point2D) {
        this.addPoint((float)point2D.getX(), (float)point2D.getY());
    }

    public void addPoint(float f2, float f3) {
        if (this.npoints == this.xpoints.length) {
            float[] fArray = new float[this.npoints << 1];
            System.arraycopy(this.xpoints, 0, fArray, 0, this.npoints);
            this.xpoints = fArray;
            fArray = new float[this.npoints << 1];
            System.arraycopy(this.ypoints, 0, fArray, 0, this.npoints);
            this.ypoints = fArray;
        }
        this.xpoints[this.npoints] = f2;
        this.ypoints[this.npoints] = f3;
        ++this.npoints;
        float f4 = f3;
        f3 = f2;
        Polygon2D polygon2D = this;
        this.b = null;
        if (polygon2D.a == null) {
            polygon2D.a = new GeneralPath(0);
            polygon2D.a.moveTo(f3, f4);
            polygon2D.bounds = new Rectangle2D.Float(f3, f4, 0.0f, 0.0f);
            return;
        }
        polygon2D.a.lineTo(f3, f4);
        float f5 = (float)polygon2D.bounds.getMaxX();
        float f6 = (float)polygon2D.bounds.getMaxY();
        float f7 = (float)polygon2D.bounds.getMinX();
        float f8 = (float)polygon2D.bounds.getMinY();
        if (f3 < f7) {
            f7 = f3;
        } else if (f3 > f5) {
            f5 = f3;
        }
        if (f4 < f8) {
            f8 = f4;
        } else if (f4 > f6) {
            f6 = f4;
        }
        polygon2D.bounds = new Rectangle2D.Float(f7, f8, f5 - f7, f6 - f8);
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n2, int n3) {
        return this.contains((double)n2, (double)n3);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    @Override
    public Rectangle getBounds() {
        if (this.bounds == null) {
            return null;
        }
        return this.bounds.getBounds();
    }

    @Override
    public boolean contains(double d2, double d3) {
        if (this.npoints <= 2 || !this.bounds.contains(d2, d3)) {
            return false;
        }
        this.b();
        return this.b.contains(d2, d3);
    }

    private void b() {
        if (this.npoints > 0 && this.b == null) {
            this.b = (GeneralPath)this.a.clone();
            this.b.closePath();
        }
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    @Override
    public boolean intersects(double d2, double d3, double d4, double d5) {
        if (this.npoints <= 0 || !this.bounds.intersects(d2, d3, d4, d5)) {
            return false;
        }
        this.b();
        return this.b.intersects(d2, d3, d4, d5);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public boolean contains(double d2, double d3, double d4, double d5) {
        if (this.npoints <= 0 || !this.bounds.intersects(d2, d3, d4, d5)) {
            return false;
        }
        this.b();
        return this.b.contains(d2, d3, d4, d5);
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        this.b();
        if (this.b == null) {
            return null;
        }
        return this.b.getPathIterator(affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return this.getPathIterator(affineTransform);
    }
}

