/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.measure;

import de.caff.util.measure.LengthUnit;
import de.caff.util.measure.a;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class PhysicalLength
implements Serializable,
Comparable {
    public static final String UNIT_FORMAT = "%f %s";
    private final double a;
    private final LengthUnit a;
    private final double b;
    public static final PhysicalLength NULL = new PhysicalLength(0.0, LengthUnit.a);

    public PhysicalLength(double d2, LengthUnit lengthUnit) {
        this.a = d2;
        this.a = lengthUnit;
        this.b = lengthUnit.a(d2);
    }

    public final LengthUnit getUnit() {
        return this.a;
    }

    public final double getLengthInMeter() {
        return this.b;
    }

    public final double getLength() {
        return this.a;
    }

    public final double getLength(LengthUnit lengthUnit) {
        return lengthUnit.a(this.a, this.a);
    }

    public final String toString() {
        return String.format(UNIT_FORMAT, this.a, this.a);
    }

    public final String toString(LengthUnit lengthUnit) {
        return String.format(UNIT_FORMAT, this.getLength(lengthUnit), lengthUnit);
    }

    public final boolean equals(PhysicalLength physicalLength, PhysicalLength physicalLength2) {
        return Math.abs(physicalLength.b - this.b) <= physicalLength2.b;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (PhysicalLength)object;
        return this.equals((PhysicalLength)object, NULL);
    }

    public final int hashCode() {
        long l2 = this.b != 0.0 ? Double.doubleToLongBits(this.b) : 0L;
        return (int)(l2 ^ l2 >>> 32);
    }

    public final PhysicalLength times(double d2) {
        return new PhysicalLength(this.a * d2, this.a);
    }

    public final PhysicalLength dividedBy(double d2) {
        return new PhysicalLength(this.a / d2, this.a);
    }

    public final double dividedBy(PhysicalLength physicalLength) {
        return this.b / physicalLength.b;
    }

    public final PhysicalLength plus(PhysicalLength physicalLength) {
        return new PhysicalLength(this.a + physicalLength.getLength(this.a), this.a);
    }

    public final PhysicalLength minus(PhysicalLength physicalLength) {
        return new PhysicalLength(this.a - physicalLength.getLength(this.a), this.a);
    }

    public final PhysicalLength in(LengthUnit lengthUnit) {
        return new PhysicalLength(lengthUnit.a(this.a, this.a), lengthUnit);
    }

    public final int compareTo(PhysicalLength physicalLength) {
        return Double.compare(this.b, physicalLength.b);
    }

    public static PhysicalLength fromString(String string, Locale serializable) {
        if ((string = string.trim()).length() < 2) {
            throw new a("String too short to contain valid physical length: " + string);
        }
        Serializable serializable2 = NumberFormat.getNumberInstance(serializable);
        ParsePosition parsePosition = new ParsePosition(0);
        serializable2 = ((NumberFormat)serializable2).parse(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new a("String does not start with a valid floating point number for locale " + serializable + ": " + string);
        }
        serializable = LengthUnit.a(string = string.substring(parsePosition.getIndex()).trim());
        if (serializable == null) {
            throw new a("Unknown length unit: " + string);
        }
        return new PhysicalLength(((Number)serializable2).doubleValue(), (LengthUnit)serializable);
    }

    public static PhysicalLength fromString(String string) {
        return PhysicalLength.fromString(string, Locale.getDefault());
    }

    public static void main(String[] stringArray) {
        for (String string : stringArray) {
            try {
                PhysicalLength physicalLength = PhysicalLength.fromString(string);
                System.out.println("Read: " + physicalLength);
            }
            catch (a a2) {
                a a3 = a2;
                a2.printStackTrace();
            }
        }
    }
}

